/*
 * Decompiled with CFR 0.152.
 */
package com.xphsc.elasticsearch.core.query;

import com.xphsc.elasticsearch.core.query.Criterion;
import java.util.Collection;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.QueryStringQueryBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.support.ValuesSourceAggregationBuilder;

public class SimpleExpression {
    private String fieldName;
    private Object value;
    private Collection<Object> values;
    private Criterion.Operator operator;
    private Object from;
    private Object to;
    private String[] fieldNames;
    private Criterion.Projection projection;
    private String asFieldName;
    private Object[] objects;

    protected SimpleExpression(String fieldName, Object value, Criterion.Operator operator) {
        this.fieldName = fieldName;
        this.value = value;
        this.operator = operator;
    }

    protected SimpleExpression(String value, Criterion.Operator operator) {
        this.value = value;
        this.operator = operator;
    }

    protected SimpleExpression(String fieldName, Collection<Object> values) {
        this.fieldName = fieldName;
        this.values = values;
        this.operator = Criterion.Operator.TERMS;
    }

    protected SimpleExpression(Criterion.Operator operator, Collection<Object> values) {
        this.values = values;
        this.operator = operator;
    }

    protected SimpleExpression(Criterion.Operator operator, String fieldName, Collection<Object> values) {
        this.fieldName = fieldName;
        this.values = values;
        this.operator = operator;
    }

    protected SimpleExpression(String fieldName, Object from, Object to, Criterion.Operator operator) {
        this.fieldName = fieldName;
        this.from = from;
        this.to = to;
        this.operator = operator;
    }

    protected SimpleExpression(String[] fieldName, Object value, Criterion.Operator operator) {
        this.fieldNames = this.fieldNames;
        this.value = value;
        this.operator = operator;
    }

    protected SimpleExpression(String[] fieldNames, Object[] objects, Criterion.Operator operator) {
        this.fieldNames = fieldNames;
        this.objects = objects;
        this.operator = operator;
    }

    protected SimpleExpression(String fieldName, String asFieldName, Criterion.Projection projection) {
        this.fieldName = fieldName;
        this.asFieldName = asFieldName;
        this.projection = projection;
    }

    protected SimpleExpression(Criterion.Operator operator, String ... ids) {
        this.objects = ids;
        this.operator = operator;
    }

    public QueryBuilder toBuilder() {
        QueryStringQueryBuilder qb = null;
        switch (this.operator) {
            case EQUAL: {
                qb = QueryBuilders.termQuery((String)this.fieldName, (Object)this.value);
                break;
            }
            case NOT_EQUAL: {
                qb = QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.termQuery((String)this.fieldName, (Object)this.value));
                break;
            }
            case OR_EQUAL: {
                qb = QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.termQuery((String)this.fieldName, (Object)this.value));
                break;
            }
            case OR_NOT_EQUAL: {
                qb = QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.termQuery((String)this.fieldName, (Object)this.value)));
                break;
            }
            case TERMS: {
                qb = QueryBuilders.termsQuery((String)this.fieldName, this.values);
                break;
            }
            case BETWEEN: {
                qb = QueryBuilders.rangeQuery((String)this.fieldName).from(this.from).to(this.to).includeLower(true);
                break;
            }
            case NOT_BETWEEN: {
                qb = QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.rangeQuery((String)this.fieldName).from(this.from).to(this.to).includeLower(true));
                break;
            }
            case OR_BETWEEN: {
                qb = QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.rangeQuery((String)this.fieldName).from(this.from).to(this.to).includeLower(true));
                break;
            }
            case OR_NOT_BETWEEN: {
                qb = QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.rangeQuery((String)this.fieldName).from(this.from).to(this.to).includeLower(true)));
                break;
            }
            case MATCH: {
                qb = QueryBuilders.matchQuery((String)this.fieldName, (Object)this.value);
                break;
            }
            case OR_MATCH: {
                qb = QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.matchQuery((String)this.fieldName, (Object)this.value));
                break;
            }
            case NOT_MATCH: {
                qb = QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.matchQuery((String)this.fieldName, (Object)this.value));
                break;
            }
            case OR_NOT_MATCH: {
                qb = QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.matchQuery((String)this.fieldName, (Object)this.value)));
                break;
            }
            case MULTI_MATCH: {
                qb = QueryBuilders.multiMatchQuery((Object)this.value, (String[])this.fieldNames);
                break;
            }
            case PREFIX: {
                qb = QueryBuilders.prefixQuery((String)this.fieldName, (String)this.value.toString());
                break;
            }
            case NOT_PREFIX: {
                qb = QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.prefixQuery((String)this.fieldName, (String)this.value.toString()));
                break;
            }
            case OR_PREFIX: {
                qb = QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.prefixQuery((String)this.fieldName, (String)this.value.toString()));
                break;
            }
            case OR_NOT_PREFIX: {
                qb = QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.prefixQuery((String)this.fieldName, (String)this.value.toString())));
                break;
            }
            case REGEXP: {
                qb = QueryBuilders.regexpQuery((String)this.fieldName, (String)this.value.toString());
                break;
            }
            case OR_REGEXP: {
                qb = QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.regexpQuery((String)this.fieldName, (String)this.value.toString()));
                break;
            }
            case QUERY_STRING: {
                qb = QueryBuilders.queryStringQuery((String)this.value.toString());
                break;
            }
            case OR_QUERY_STRING: {
                qb = QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.queryStringQuery((String)this.value.toString()));
                break;
            }
            case LIKE: {
                qb = QueryBuilders.wildcardQuery((String)this.fieldName, (String)this.value.toString());
                break;
            }
            case NOT_LIKE: {
                qb = QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.wildcardQuery((String)this.fieldName, (String)this.value.toString()));
                break;
            }
            case OR_LIKE: {
                qb = QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.wildcardQuery((String)this.fieldName, (String)this.value.toString()));
                break;
            }
            case OR_NOT_LIKE: {
                qb = QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.wildcardQuery((String)this.fieldName, (String)this.value.toString())));
                break;
            }
            case GREATER_THAN: {
                qb = QueryBuilders.rangeQuery((String)this.fieldName).gt(this.value);
                break;
            }
            case OR_GREATER_THAN: {
                qb = QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.rangeQuery((String)this.fieldName).gt(this.value));
                break;
            }
            case GTE: {
                qb = QueryBuilders.rangeQuery((String)this.fieldName).gte(this.value);
                break;
            }
            case OR_GTE: {
                qb = QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.rangeQuery((String)this.fieldName).gte(this.value));
                break;
            }
            case LT: {
                qb = QueryBuilders.rangeQuery((String)this.fieldName).lt(this.value);
                break;
            }
            case OR_LT: {
                qb = QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.rangeQuery((String)this.fieldName).lt(this.value));
                break;
            }
            case LTE: {
                qb = QueryBuilders.rangeQuery((String)this.fieldName).lte(this.value);
                break;
            }
            case OR_LTE: {
                qb = QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.rangeQuery((String)this.fieldName).lte(this.value));
                break;
            }
            case IN: {
                qb = QueryBuilders.termsQuery((String)this.fieldName, this.values);
                break;
            }
            case NOT_IN: {
                qb = QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.termsQuery((String)this.fieldName, this.values));
                break;
            }
            case OR_IN: {
                qb = QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.termsQuery((String)this.fieldName, this.values));
                break;
            }
            case OR_NOR_IN: {
                qb = QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.termsQuery((String)this.fieldName, this.values)));
                break;
            }
            case IN_IDS: {
                qb = QueryBuilders.termsQuery((String)"_id", this.values);
                break;
            }
            case NOT_IN_IDS: {
                qb = QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.termsQuery((String)"_id", this.values));
                break;
            }
            case OR_IN_IDS: {
                qb = QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.termsQuery((String)"_id", this.values));
                break;
            }
            case OR_NOR_IN_IDS: {
                qb = QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.termsQuery((String)"_id", this.values)));
                break;
            }
            case MORE_LIKE: {
                qb = QueryBuilders.moreLikeThisQuery((String[])this.fieldNames, (String[])new String[]{this.objects.toString()}, null);
                break;
            }
            case IS_NULL: {
                qb = QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.existsQuery((String)this.value.toString()));
                break;
            }
            case OR_IS_NULL: {
                qb = QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.boolQuery().mustNot((QueryBuilder)QueryBuilders.existsQuery((String)this.value.toString())));
                break;
            }
            case OR_IS_NOT_NULL: {
                qb = QueryBuilders.boolQuery().should((QueryBuilder)QueryBuilders.existsQuery((String)this.value.toString()));
                break;
            }
            case IS_NOT_NULL: {
                qb = QueryBuilders.existsQuery((String)this.value.toString());
            }
        }
        return qb;
    }

    public AggregationBuilder toAggBuilder() {
        ValuesSourceAggregationBuilder agg = null;
        switch (this.projection) {
            case MAX: {
                agg = AggregationBuilders.max((String)this.asFieldName).field(this.fieldName);
                break;
            }
            case MIN: {
                agg = AggregationBuilders.min((String)this.asFieldName).field(this.fieldName);
                break;
            }
            case AVG: {
                agg = AggregationBuilders.avg((String)this.asFieldName).field(this.fieldName);
                break;
            }
            case SUM: {
                agg = AggregationBuilders.sum((String)this.asFieldName).field(this.fieldName);
                break;
            }
            case COUNT: {
                agg = AggregationBuilders.count((String)this.asFieldName).field(this.fieldName);
                break;
            }
            case MISSING: {
                agg = AggregationBuilders.missing((String)this.asFieldName).field(this.fieldName);
                break;
            }
            case TERMS: {
                agg = AggregationBuilders.terms((String)this.asFieldName).field(this.fieldName);
                break;
            }
            case RANGE: {
                agg = AggregationBuilders.range((String)this.asFieldName).field(this.fieldName);
                break;
            }
        }
        return agg;
    }
}

