/*
 * Decompiled with CFR 0.152.
 */
package com.xphsc.elasticsearch.core.support;

import com.xphsc.elasticsearch.core.client.RestHighLevelClientBulider;
import com.xphsc.elasticsearch.util.Strings;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.apache.http.impl.nio.reactor.IOReactorConfig;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;

public class ElasticsearchAccessor {
    private RestHighLevelClientBulider client;
    private RestClient restClient = null;
    private String userName;
    private String password;
    private String[] uris = new String[0];
    private String proxyHost;
    private Integer proxyPort;
    private int connectTimeout;
    private int socketTimeout;
    private int connectionRequestTimeout;
    private int maxRetryTimeoutMillis;

    public RestHighLevelClientBulider initClient() {
        if (null == this.client) {
            RestClientBuilder builder = null;
            if (this.uris != null && Strings.isBlank(this.proxyHost)) {
                for (String uri : this.uris) {
                    String url = Strings.substringAfter(uri, "http://");
                    String[] urls = url.split(":");
                    String host = urls[0];
                    int port = Integer.parseInt(urls[1]);
                    builder = RestClient.builder((HttpHost[])new HttpHost[]{new HttpHost(host, port, "http")});
                }
            }
            if (Strings.isNotBlank(this.proxyHost) && this.proxyPort != 0) {
                builder = RestClient.builder((HttpHost[])new HttpHost[]{new HttpHost(this.proxyHost, this.proxyPort.intValue(), "http")});
            }
            builder.setHttpClientConfigCallback(new RestClientBuilder.HttpClientConfigCallback(){

                public HttpAsyncClientBuilder customizeHttpClient(HttpAsyncClientBuilder config) {
                    config.setDefaultIOReactorConfig(IOReactorConfig.custom().setIoThreadCount(100).build());
                    if (!Strings.isEmpty(ElasticsearchAccessor.this.userName) && !Strings.isEmpty(ElasticsearchAccessor.this.password)) {
                        BasicCredentialsProvider credential = new BasicCredentialsProvider();
                        credential.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(ElasticsearchAccessor.this.userName, ElasticsearchAccessor.this.password));
                        config.setDefaultCredentialsProvider((CredentialsProvider)credential);
                    }
                    return config;
                }
            });
            builder.setRequestConfigCallback(new RestClientBuilder.RequestConfigCallback(){

                public RequestConfig.Builder customizeRequestConfig(RequestConfig.Builder config) {
                    if (ElasticsearchAccessor.this.connectTimeout != 0) {
                        config.setConnectTimeout(ElasticsearchAccessor.this.connectTimeout);
                    }
                    if (ElasticsearchAccessor.this.socketTimeout != 0) {
                        config.setSocketTimeout(ElasticsearchAccessor.this.socketTimeout);
                    }
                    if (ElasticsearchAccessor.this.connectionRequestTimeout != 0) {
                        config.setConnectionRequestTimeout(ElasticsearchAccessor.this.connectionRequestTimeout);
                    }
                    return config;
                }
            });
            if (this.maxRetryTimeoutMillis != 0) {
                builder.setMaxRetryTimeoutMillis(this.maxRetryTimeoutMillis);
            }
            this.restClient = builder.build();
            this.client = new RestHighLevelClientBulider(builder);
        }
        return this.client;
    }

    public void setClient(RestHighLevelClientBulider client) {
        this.client = client;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public RestClient getRestClient() {
        return this.client.getLowLevelClient();
    }

    public void setRestClient(RestClient restClient) {
        this.restClient = restClient;
    }

    public String[] getUris() {
        return this.uris;
    }

    public void setUris(String[] uris) {
        this.uris = uris;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public Integer getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(Integer proxyPort) {
        this.proxyPort = proxyPort;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public int getConnectionRequestTimeout() {
        return this.connectionRequestTimeout;
    }

    public void setConnectionRequestTimeout(int connectionRequestTimeout) {
        this.connectionRequestTimeout = connectionRequestTimeout;
    }

    public int getMaxRetryTimeoutMillis() {
        return this.maxRetryTimeoutMillis;
    }

    public void setMaxRetryTimeoutMillis(int maxRetryTimeoutMillis) {
        this.maxRetryTimeoutMillis = maxRetryTimeoutMillis;
    }
}

