/*
 * Decompiled with CFR 0.152.
 */
package com.xphsc.elasticsearch.util;

import com.xphsc.elasticsearch.core.exception.ElasticsearchException;
import com.xphsc.elasticsearch.util.Collects;
import com.xphsc.elasticsearch.util.Objects;
import com.xphsc.elasticsearch.util.Strings;
import java.util.Collection;
import java.util.Map;

public class Asserts {
    public static void state(boolean expression, String message) {
        if (!expression) {
            throw new ElasticsearchException(message);
        }
    }

    public static void isTrue(boolean expression, String message) {
        if (!expression) {
            throw new ElasticsearchException(message);
        }
    }

    public static void isNull(Object object, String message) {
        if (object != null) {
            throw new ElasticsearchException(message);
        }
    }

    public static void notNull(Object object, String message) {
        if (object == null) {
            throw new ElasticsearchException(message);
        }
    }

    public static void hasLength(String text, String message) {
        if (!Strings.hasLength(text)) {
            throw new ElasticsearchException(message);
        }
    }

    public static void hasText(String text, String message) {
        if (!Strings.hasText(text)) {
            throw new ElasticsearchException(message);
        }
    }

    public static void doesNotContain(String textToSearch, String substring, String message) {
        if (Strings.hasLength(textToSearch) && Strings.hasLength(substring) && textToSearch.contains(substring)) {
            throw new ElasticsearchException(message);
        }
    }

    public static void notEmpty(Object[] array, String message) {
        if (Objects.isEmpty(array)) {
            throw new ElasticsearchException(message);
        }
    }

    public static void noNullElements(Object[] array, String message) {
        if (array != null) {
            for (Object element : array) {
                if (element != null) continue;
                throw new ElasticsearchException(message);
            }
        }
    }

    public static void notEmpty(Collection<?> collection, String message) {
        if (Collects.isEmpty(collection)) {
            throw new ElasticsearchException(message);
        }
    }

    public static void notEmpty(Map<?, ?> map, String message) {
        if (Collects.isEmpty(map)) {
            throw new ElasticsearchException(message);
        }
    }

    public static void isInstanceOf(Class<?> type, Object obj, String message) {
        Asserts.notNull(type, "Type to check against must not be null");
        if (!type.isInstance(obj)) {
            Asserts.instanceCheckFailed(type, obj, message);
        }
    }

    public static void isInstanceOf(Class<?> type, Object obj) {
        Asserts.isInstanceOf(type, obj, "");
    }

    public static void isAssignable(Class<?> superType, Class<?> subType, String message) {
        Asserts.notNull(superType, "Super type to check against must not be null");
        if (subType == null || !superType.isAssignableFrom(subType)) {
            Asserts.assignableCheckFailed(superType, subType, message);
        }
    }

    public static void isAssignable(Class<?> superType, Class<?> subType) {
        Asserts.isAssignable(superType, subType, "");
    }

    private static void instanceCheckFailed(Class<?> type, Object obj, String msg) {
        String className = obj != null ? obj.getClass().getName() : "null";
        String result = "";
        boolean defaultMessage = true;
        if (Strings.hasLength(msg)) {
            if (Asserts.endsWithSeparator(msg)) {
                result = msg + " ";
            } else {
                result = Asserts.messageWithTypeName(msg, className);
                defaultMessage = false;
            }
        }
        if (defaultMessage) {
            result = result + "Object of class [" + className + "] must be an instance of " + type;
        }
        throw new IllegalArgumentException(result);
    }

    private static void assignableCheckFailed(Class<?> superType, Class<?> subType, String msg) {
        String result = "";
        boolean defaultMessage = true;
        if (Strings.hasLength(msg)) {
            if (Asserts.endsWithSeparator(msg)) {
                result = msg + " ";
            } else {
                result = Asserts.messageWithTypeName(msg, subType);
                defaultMessage = false;
            }
        }
        if (defaultMessage) {
            result = result + subType + " is not assignable to " + superType;
        }
        throw new IllegalArgumentException(result);
    }

    private static boolean endsWithSeparator(String msg) {
        return msg.endsWith(":") || msg.endsWith(";") || msg.endsWith(",") || msg.endsWith(".");
    }

    private static String messageWithTypeName(String msg, Object typeName) {
        return msg + (msg.endsWith(" ") ? "" : ": ") + typeName;
    }
}

