/*
 * Decompiled with CFR 0.152.
 */
package com.xphsc.elasticsearch.util;

import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Collects {
    public static boolean isEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isEmpty(Iterable<?> iterable) {
        return null == iterable || Collects.isEmpty(iterable.iterator());
    }

    public static boolean isEmpty(Iterator<?> iterable) {
        return null == iterable || !iterable.hasNext();
    }

    public static boolean isNotEmpty(Collection<?> collection) {
        return !Collects.isEmpty(collection);
    }

    public static boolean isNotEmpty(Iterable<?> iterable) {
        return null != iterable && Collects.isNotEmpty(iterable.iterator());
    }

    public static boolean isNotEmpty(Iterator<?> iterable) {
        return null != iterable && iterable.hasNext();
    }

    public static boolean isEmpty(Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    public static boolean isNotEmpty(Map<?, ?> map) {
        return !Collects.isEmpty(map);
    }

    public static <E> List<E> removeAll(Collection<E> collection, Collection<?> remove) {
        ArrayList<E> list = new ArrayList<E>();
        for (E obj : collection) {
            if (remove.contains(obj)) continue;
            list.add(obj);
        }
        return list;
    }

    public static <T> boolean isEmpty(T[] array) {
        return array == null || array.length == 0;
    }

    public static <T> T[] toArray(T ... arrays) {
        return Collects.toArray(arrays);
    }

    public static <K> String getStringValue(Map<? super K, ?> map, K key) {
        Number value = Collects.getNumber(map, key);
        return value == null ? null : String.valueOf(value);
    }

    public static <K> Integer getInteger(Map<? super K, ?> map, K key) {
        Number value = Collects.getNumber(map, key);
        return value == null ? null : (value instanceof Integer ? (Integer)value : Integer.valueOf(value.intValue()));
    }

    public static <K> Number getNumber(Map<? super K, ?> map, K key) {
        Object value;
        if (map != null && (value = map.get(key)) != null) {
            if (value instanceof Number) {
                return (Number)value;
            }
            if (value instanceof String) {
                try {
                    String e = (String)value;
                    return NumberFormat.getInstance().parse(e);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
        }
        return null;
    }
}

