/*
 * Decompiled with CFR 0.152.
 */
package com.xphsc.elasticsearch.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.xphsc.elasticsearch.core.entity.SearchHit;
import com.xphsc.elasticsearch.page.Page;
import com.xphsc.elasticsearch.page.PageImpl;
import com.xphsc.elasticsearch.util.Beans;
import com.xphsc.elasticsearch.util.Collects;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightField;

public class ElasticsearchHelpper {
    public static <T> Iterable<T> formatToEntity(SearchHits hits, Class<T> clazz) {
        org.elasticsearch.search.SearchHit[] searchHists;
        ArrayList<Object> result = new ArrayList<Object>(Integer.parseInt(hits.getTotalHits() + ""));
        for (org.elasticsearch.search.SearchHit sh : searchHists = hits.getHits()) {
            Map maps = sh.getHighlightFields();
            if (Collects.isNotEmpty(maps)) {
                for (Map.Entry map : maps.entrySet()) {
                    HighlightField highlight;
                    Text[] fragments;
                    if (!sh.getSourceAsMap().containsKey(map.getKey()) || (fragments = (highlight = (HighlightField)map.getValue()).fragments()) == null) continue;
                    sh.getSourceAsMap().put(highlight.getName(), fragments[0].string());
                }
            }
            Object t = JSON.parseObject((String)ElasticsearchHelpper.toJsonWithId(JSON.toJSONString((Object)sh.getSourceAsMap()), Beans.getIdName(clazz), sh.getId()), clazz);
            result.add(t);
        }
        return result;
    }

    public static <T> Page<T> formatToPageEntity(com.xphsc.elasticsearch.core.entity.SearchHits searchHits, Class<T> clazz, long total, Integer pageNum, Integer pageSize) {
        SearchHit[] hits;
        ArrayList<Object> result = new ArrayList<Object>(Integer.parseInt(searchHits.getTotal() + ""));
        for (SearchHit hit : hits = searchHits.getHits()) {
            Object t = JSON.parseObject((String)ElasticsearchHelpper.toJsonWithId(JSON.toJSONString(hit.get_source()), Beans.getIdName(clazz), hit.get_id()), clazz);
            result.add(t);
        }
        PageImpl page = new PageImpl(result, total, pageNum, pageSize);
        return page;
    }

    public static <T> Page<T> formatToPageByEntity(SearchHits hits, Class<T> clazz, short querySizeMax, Integer pageNum, Integer pageSize) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (org.elasticsearch.search.SearchHit hit : hits) {
            Map maps = hit.getHighlightFields();
            if (Collects.isNotEmpty(maps)) {
                for (Map.Entry map : maps.entrySet()) {
                    HighlightField highlight;
                    Text[] fragments;
                    if (!hit.getSourceAsMap().containsKey(map.getKey()) || (fragments = (highlight = (HighlightField)map.getValue()).fragments()) == null) continue;
                    hit.getSourceAsMap().put(highlight.getName(), fragments[0].string());
                }
            }
            Object t = JSON.parseObject((String)ElasticsearchHelpper.toJsonWithId(JSON.toJSONString((Object)hit.getSourceAsMap()), Beans.getIdName(clazz), hit.getId()), clazz);
            result.add(t);
        }
        long total = hits.getTotalHits();
        PageImpl page = new PageImpl(result, total, pageNum, pageSize);
        return page;
    }

    public static List<Map<String, Object>> formatToMap(SearchHits hits) {
        org.elasticsearch.search.SearchHit[] searchHists;
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(Integer.parseInt(hits.getTotalHits() + ""));
        for (org.elasticsearch.search.SearchHit sh : searchHists = hits.getHits()) {
            Map map = sh.getSourceAsMap();
            result.add(map);
        }
        return result;
    }

    public static final Map<String, Object> formatAgg(Aggregations aggregations, String name) {
        Map map = (Map)JSON.parseObject((String)JSON.toJSON(aggregations.asMap().get(name)).toString(), Map.class);
        HashMap<String, Object> result = new HashMap<String, Object>();
        Object value = null;
        for (Map.Entry valueObj : map.entrySet()) {
            if ("value".equals(valueObj.getKey())) {
                value = valueObj.getValue();
            }
            result.put(name, value);
        }
        return result;
    }

    public static final <T> List<Map<String, Object>> formatAggAsMap(SearchHits hits, Aggregations aggregations, Class<T> clazz, String name) {
        org.elasticsearch.search.SearchHit[] searchHists;
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        Map map = (Map)JSON.parseObject((String)JSON.toJSON(aggregations.asMap().get(name)).toString(), Map.class);
        Map<Object, Object> objectMap = new HashMap();
        for (org.elasticsearch.search.SearchHit sh : searchHists = hits.getHits()) {
            Object t = JSON.parseObject((String)ElasticsearchHelpper.toJsonWithId(JSON.toJSONString((Object)sh.getSourceAsMap()), Beans.getIdName(clazz), sh.getId()), clazz);
            objectMap = Beans.objectToMap(t);
            for (Map.Entry objectEntry : map.entrySet()) {
                Object value = null;
                if (!"value".equals(objectEntry.getKey())) continue;
                value = objectEntry.getValue();
                objectMap.put(name, value);
            }
            result.add(objectMap);
        }
        return result;
    }

    public static String format(String origin) {
        if (origin.indexOf(".") > 0) {
            origin = origin.substring(origin.lastIndexOf(".") + 1);
            origin = origin.toLowerCase();
        }
        if ("int".equals(origin)) {
            origin = "integer";
        }
        return origin;
    }

    public static String toJsonWithId(String source, String idName, String idValue) {
        JSONObject jsonObject = JSON.parseObject((String)source);
        jsonObject.put(idName, (Object)idValue);
        return JSON.toJSONString((Object)jsonObject);
    }
}

