/*
 * Decompiled with CFR 0.152.
 */
package com.github.yafeiwang124.common.tcp.network.server;

import com.alibaba.fastjson.JSONObject;
import com.github.yafeiwang124.common.tcp.network.handler.IRequestCallback;
import com.github.yafeiwang124.common.tcp.network.server.ITcpClient;
import com.github.yafeiwang124.common.tcp.protocol.MessageContext;
import com.github.yafeiwang124.common.tcp.protocol.codec.ProtocolDecoder;
import com.github.yafeiwang124.common.tcp.protocol.codec.ProtocolEncoder;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import java.io.IOException;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TcpClient
implements ITcpClient {
    private static final Logger logger = LoggerFactory.getLogger(TcpClient.class);
    private Bootstrap bootstrap;
    private EventLoopGroup loopGroup;
    private int threads;
    private String host;
    private int port;
    private Map<String, IRequestCallback> callbacks = new ConcurrentHashMap<String, IRequestCallback>();
    private ChannelFuture channelFuture;

    public TcpClient(int threads, String host, int port) throws InterruptedException {
        this.threads = threads;
        this.host = host;
        this.port = port;
        this.init();
    }

    private void init() throws InterruptedException {
        this.loopGroup = new NioEventLoopGroup(this.threads);
        this.bootstrap = new Bootstrap();
        this.channelFuture = ((Bootstrap)((Bootstrap)((Bootstrap)this.bootstrap.group(this.loopGroup)).channel(NioSocketChannel.class)).remoteAddress(this.host, this.port).handler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) throws Exception {
                ch.pipeline().addLast("decoder", (ChannelHandler)new ProtocolDecoder()).addLast("encoder", (ChannelHandler)new ProtocolEncoder()).addLast("responseHandler", (ChannelHandler)new ResponseHandler());
            }
        })).connect().sync();
    }

    @Override
    public void tell(Object message, IRequestCallback callback) throws Exception {
        MessageContext messageContext = new MessageContext(UUID.randomUUID().toString(), message);
        if (callback != null) {
            this.callbacks.put(messageContext.getMessageId(), callback);
        }
        this.channelFuture.channel().writeAndFlush((Object)messageContext).sync();
    }

    @Override
    public Object ask(Object request) throws Exception {
        CompletableFuture<Object> future = new CompletableFuture<Object>();
        SynResponseCallback callback = new SynResponseCallback(future);
        this.tell(request, callback);
        return future.get();
    }

    @Override
    public Object ask(Object request, long timeout) throws Exception {
        CompletableFuture<Object> future = new CompletableFuture<Object>();
        SynResponseCallback callback = new SynResponseCallback(future);
        this.tell(request, callback);
        return future.get(timeout, TimeUnit.MILLISECONDS);
    }

    @Override
    public boolean isActive() {
        return this.channelFuture.channel().isActive() || this.channelFuture.channel().isOpen() || this.channelFuture.channel().isRegistered();
    }

    @Override
    public void close() throws IOException {
        if (this.isActive()) {
            try {
                this.channelFuture.channel().close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.loopGroup.shutdownGracefully();
    }

    private class SynResponseCallback
    implements IRequestCallback {
        CompletableFuture<Object> future;

        public SynResponseCallback(CompletableFuture<Object> future) {
            this.future = future;
        }

        @Override
        public void invoke(Object message) {
            this.future.complete(message);
        }

        @Override
        public void onFail(String exceptionMessage) {
            this.future.completeExceptionally(new Exception(exceptionMessage));
        }
    }

    private class ResponseHandler
    extends SimpleChannelInboundHandler<MessageContext> {
        private ResponseHandler() {
        }

        protected void channelRead0(ChannelHandlerContext ctx, MessageContext msg) throws Exception {
            logger.info("\u6536\u5230\u54cd\u5e94\uff0c{}\uff0c {}", msg.getMessage(), (Object)JSONObject.toJSONString((Object)msg));
            if (TcpClient.this.callbacks.containsKey(msg.getMessageId())) {
                if (msg.isSucceed()) {
                    ((IRequestCallback)TcpClient.this.callbacks.get(msg.getMessageId())).invoke(msg.getMessage());
                } else {
                    ((IRequestCallback)TcpClient.this.callbacks.get(msg.getMessageId())).onFail(msg.getExceptionMessage());
                }
                TcpClient.this.callbacks.remove(msg.getMessageId());
            }
        }
    }
}

