/*
 * Decompiled with CFR 0.152.
 */
package com.github.yafeiwang124.common.tcp.network.server;

import com.alibaba.fastjson.JSONObject;
import com.github.yafeiwang124.common.tcp.network.handler.IRequesthandler;
import com.github.yafeiwang124.common.tcp.protocol.MessageContext;
import com.github.yafeiwang124.common.tcp.protocol.VoidProtocol;
import com.github.yafeiwang124.common.tcp.protocol.codec.ProtocolDecoder;
import com.github.yafeiwang124.common.tcp.protocol.codec.ProtocolEncoder;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TcpServer
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(TcpServer.class);
    private EventLoopGroup parentGroup;
    private EventLoopGroup workerGroup;
    private ServerBootstrap serverBootstrap;
    private int port;
    private ChannelFuture channelFuture;
    private Map<Class, IRequesthandler<?, ?>> handlerMap = new ConcurrentHashMap();

    public TcpServer() {
        this(1240, 2, 40);
    }

    public TcpServer(int port, int parentThreads, int workerThreads) {
        this.port = port;
        this.parentGroup = new NioEventLoopGroup(parentThreads);
        this.workerGroup = new NioEventLoopGroup(workerThreads);
    }

    public TcpServer addHandler(IRequesthandler handler) {
        this.handlerMap.put(handler.messageType(), handler);
        return this;
    }

    public TcpServer addHandlers(List<IRequesthandler> handlers) {
        handlers.forEach(item -> this.addHandler((IRequesthandler)item));
        return this;
    }

    public TcpServer start() throws InterruptedException {
        this.serverBootstrap = new ServerBootstrap();
        this.channelFuture = ((ServerBootstrap)((ServerBootstrap)this.serverBootstrap.group(this.parentGroup, this.workerGroup).channel(NioServerSocketChannel.class)).localAddress(this.port)).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel ch) throws Exception {
                ch.pipeline().addLast("decoder", (ChannelHandler)new ProtocolDecoder()).addLast("encoder", (ChannelHandler)new ProtocolEncoder()).addLast("handlerAdapter", (ChannelHandler)new RequestMappingHandler());
            }
        }).bind(this.port).sync();
        if (this.port == 0) {
            InetSocketAddress address = (InetSocketAddress)this.channelFuture.channel().localAddress();
            this.port = address.getPort();
        }
        return this;
    }

    public TcpServer sync() throws InterruptedException {
        this.channelFuture.channel().closeFuture().sync();
        return this;
    }

    public IRequesthandler getHandler(Class type) {
        Class<?>[] types;
        if (type == null) {
            return null;
        }
        if (type == Object.class) {
            return this.handlerMap.get(type);
        }
        if (this.handlerMap.containsKey(type)) {
            return this.handlerMap.get(type);
        }
        IRequesthandler handler = this.getHandler(type.getSuperclass());
        if (handler != null) {
            return handler;
        }
        for (Class<?> _type : types = type.getInterfaces()) {
            handler = this.getHandler(_type);
            if (handler == null) continue;
            return handler;
        }
        return null;
    }

    public int getPort() {
        return this.port;
    }

    @Override
    public void close() throws IOException {
        this.parentGroup.shutdownGracefully();
        this.workerGroup.shutdownGracefully();
    }

    @ChannelHandler.Sharable
    private class RequestMappingHandler
    extends SimpleChannelInboundHandler<MessageContext> {
        private RequestMappingHandler() {
        }

        protected void channelRead0(ChannelHandlerContext ctx, MessageContext msg) throws Exception {
            Class<?> typeClass = msg.getMessage().getClass();
            IRequesthandler handler = TcpServer.this.getHandler(typeClass);
            logger.info("\u6536\u5230\u8bf7\u6c42\uff0c\u7c7b\u578b{}\uff0c\u5185\u5bb9{}", typeClass, (Object)JSONObject.toJSONString((Object)msg));
            if (handler != null) {
                try {
                    Object result = handler.handle(msg.getMessage());
                    MessageContext context = new MessageContext(msg.getMessageId(), result);
                    logger.info("\u8fd4\u56de\u7ed3\u679c\uff1a" + JSONObject.toJSONString((Object)context));
                    ctx.channel().writeAndFlush((Object)context);
                }
                catch (Exception e) {
                    logger.error("\u8bf7\u6c42\u5904\u7406\u5f02\u5e38\uff01" + JSONObject.toJSONString((Object)msg.getMessage()), (Throwable)e);
                    MessageContext context = new MessageContext(msg.getMessageId(), VoidProtocol.getInstance());
                    context.setSucceed(false);
                    context.setExceptionMessage(e.getMessage());
                    ctx.channel().writeAndFlush((Object)context);
                }
            } else {
                MessageContext context = new MessageContext(msg.getMessageId(), VoidProtocol.getInstance());
                context.setSucceed(false);
                context.setExceptionMessage("\u4e0d\u652f\u6301\u7684\u6d88\u606f\u7c7b\u578b\uff01");
                logger.info("\u8fd4\u56de\u7ed3\u679c\uff1a" + JSONObject.toJSONString((Object)context));
                ctx.channel().writeAndFlush((Object)context);
            }
        }
    }
}

