/*
 * Decompiled with CFR 0.152.
 */
package com.github.ygimenez.model.helper;

import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.User;
import net.dv8tion.jda.api.interactions.components.LayoutComponent;
import net.dv8tion.jda.api.utils.messages.MessageRequest;
import org.jetbrains.annotations.Nullable;

public abstract class BaseHelper<Helper extends BaseHelper<Helper, T>, T> {
    private final Class<Helper> subClass;
    private final T content;
    private final boolean useButtons;
    private boolean cancellable = true;
    private long time = 0L;
    private Predicate<User> canInteract = null;

    protected BaseHelper(Class<Helper> subClass, T buttons, boolean useButtons) {
        this.subClass = subClass;
        this.content = buttons;
        this.useButtons = useButtons;
    }

    public T getContent() {
        return this.content;
    }

    public boolean isUsingButtons() {
        return this.useButtons;
    }

    public boolean isCancellable() {
        return this.cancellable;
    }

    public Helper setCancellable(boolean cancellable) {
        this.cancellable = cancellable;
        return (Helper)((BaseHelper)this.subClass.cast(this));
    }

    public long getTimeout() {
        return this.time;
    }

    public Helper setTimeout(int time, TimeUnit unit) {
        if (unit != null) {
            this.time = TimeUnit.MILLISECONDS.convert(time, unit);
        }
        return (Helper)((BaseHelper)this.subClass.cast(this));
    }

    public boolean canInteract(User user) {
        return this.canInteract == null || this.canInteract.test(user);
    }

    public Helper setCanInteract(@Nullable Predicate<User> canInteract) {
        this.canInteract = canInteract;
        return (Helper)((BaseHelper)this.subClass.cast(this));
    }

    public abstract <Out extends MessageRequest<Out>> List<LayoutComponent> getComponents(Out var1);

    public <Out extends MessageRequest<Out>> Out apply(Out action) {
        return (Out)action.setComponents(this.getComponents(action));
    }

    public abstract boolean shouldUpdate(Message var1);
}

