/*
 * Decompiled with CFR 0.152.
 */
package com.github.ygimenez.model.helper;

import com.github.ygimenez.method.Pages;
import com.github.ygimenez.model.ButtonWrapper;
import com.github.ygimenez.model.ThrowingConsumer;
import com.github.ygimenez.model.helper.BaseHelper;
import com.github.ygimenez.type.Emote;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.emoji.Emoji;
import net.dv8tion.jda.api.interactions.components.ActionRow;
import net.dv8tion.jda.api.interactions.components.LayoutComponent;
import net.dv8tion.jda.api.interactions.components.buttons.Button;
import net.dv8tion.jda.api.utils.messages.MessageRequest;

public class ButtonizeHelper
extends BaseHelper<ButtonizeHelper, Map<Emoji, ThrowingConsumer<ButtonWrapper>>> {
    private Consumer<Message> onFinalization = null;

    public ButtonizeHelper(boolean useButtons) {
        super(ButtonizeHelper.class, new LinkedHashMap(), useButtons);
    }

    public ButtonizeHelper(Map<Emoji, ThrowingConsumer<ButtonWrapper>> buttons, boolean useButtons) {
        super(ButtonizeHelper.class, buttons, useButtons);
    }

    public ButtonizeHelper addAction(Emoji emoji, ThrowingConsumer<ButtonWrapper> action) {
        ((Map)this.getContent()).put(emoji, action);
        return this;
    }

    public Consumer<Message> getOnFinalization() {
        return this.onFinalization;
    }

    public ButtonizeHelper setOnFinalization(Consumer<Message> onFinalization) {
        this.onFinalization = onFinalization;
        return this;
    }

    @Override
    public <Out extends MessageRequest<Out>> List<LayoutComponent> getComponents(Out action) {
        if (!this.isUsingButtons()) {
            return List.of();
        }
        ArrayList<LayoutComponent> rows = new ArrayList<LayoutComponent>();
        ArrayList<Button> row = new ArrayList<Button>();
        for (Emoji k : ((Map)this.getContent()).keySet()) {
            if (row.size() == 5) {
                rows.add((LayoutComponent)ActionRow.of(row));
                row = new ArrayList();
            }
            row.add(Button.secondary((String)Emote.getId(k), (Emoji)k));
        }
        if (!((Map)this.getContent()).containsKey(Pages.getPaginator().getEmoji(Emote.CANCEL)) && this.isCancellable()) {
            Button button = Button.danger((String)Emote.CANCEL.name(), (Emoji)Pages.getPaginator().getEmoji(Emote.CANCEL));
            if (rows.size() == 5 && row.size() == 5) {
                row.set(4, button);
            } else if (row.size() == 5) {
                rows.add((LayoutComponent)ActionRow.of(row));
                row = new ArrayList();
                row.add(button);
            } else {
                row.add(button);
            }
        }
        rows.add((LayoutComponent)ActionRow.of(row));
        return rows;
    }

    @Override
    public boolean shouldUpdate(Message msg) {
        if (!this.isUsingButtons()) {
            return false;
        }
        Predicate<Set> checks = e -> !this.isCancellable() || e.contains(Pages.getPaginator().getEmoji(Emote.CANCEL));
        Set emojis = msg.getButtons().stream().map(Button::getEmoji).collect(Collectors.toSet());
        return !(checks = checks.and(e -> e.containsAll(((Map)this.getContent()).keySet()))).test(emojis);
    }
}

