/*
 * Decompiled with CFR 0.152.
 */
package com.github.ygimenez.type;

import com.github.ygimenez.method.Pages;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import net.dv8tion.jda.api.entities.MessageReaction;
import net.dv8tion.jda.api.entities.emoji.CustomEmoji;
import net.dv8tion.jda.api.entities.emoji.Emoji;
import net.dv8tion.jda.api.entities.emoji.EmojiUnion;
import net.dv8tion.jda.api.interactions.components.buttons.Button;
import net.dv8tion.jda.api.interactions.components.buttons.ButtonStyle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum Emote {
    NEXT((Emoji)Emoji.fromUnicode((String)"\u25b6"), ButtonStyle.SECONDARY),
    PREVIOUS((Emoji)Emoji.fromUnicode((String)"\u25c0"), ButtonStyle.SECONDARY),
    ACCEPT((Emoji)Emoji.fromUnicode((String)"\u2705"), ButtonStyle.SUCCESS),
    CANCEL((Emoji)Emoji.fromUnicode((String)"\u274e"), ButtonStyle.DANGER),
    SKIP_FORWARD((Emoji)Emoji.fromUnicode((String)"\u23e9"), ButtonStyle.SECONDARY),
    SKIP_BACKWARD((Emoji)Emoji.fromUnicode((String)"\u23ea"), ButtonStyle.SECONDARY),
    GOTO_FIRST((Emoji)Emoji.fromUnicode((String)"\u23ee"), ButtonStyle.SECONDARY),
    GOTO_LAST((Emoji)Emoji.fromUnicode((String)"\u23ed"), ButtonStyle.SECONDARY),
    NONE(null, ButtonStyle.SECONDARY);

    private final Emoji emj;
    private final ButtonStyle style;

    private Emote(Emoji emj, ButtonStyle style) {
        this.emj = emj;
        this.style = style;
    }

    public Emoji getDefault() {
        return this.emj;
    }

    public ButtonStyle getStyle() {
        return this.style;
    }

    public static Emote getByEmoji(@NotNull Emoji emoji) {
        for (Map.Entry<Emote, Emoji> entry : Pages.getPaginator().getEmotes().entrySet()) {
            if (!Objects.equals(entry.getValue(), emoji)) continue;
            return entry.getKey();
        }
        for (Emote emt : Emote.values()) {
            if (!Objects.equals(emt.emj, emoji)) continue;
            return emt;
        }
        return NONE;
    }

    public static boolean isNative(@NotNull Button btn) {
        if (btn.getId() == null) {
            return false;
        }
        for (Emote emt : Emote.values()) {
            if (!emt.name().equals(btn.getId())) continue;
            return true;
        }
        return false;
    }

    public static boolean isNative(@NotNull MessageReaction react) {
        EmojiUnion emj = Emoji.fromFormatted((String)react.getEmoji().getAsReactionCode());
        for (Emote emt : Emote.values()) {
            if (!emt.emj.equals(emj)) continue;
            return false;
        }
        return true;
    }

    public static String getId(@NotNull Emoji emj) {
        if (emj instanceof CustomEmoji) {
            return ((CustomEmoji)emj).getId();
        }
        return emj.getName();
    }

    @Nullable
    public static Emote fromButton(@NotNull Button btn) {
        return Arrays.stream(Emote.values()).filter(e -> btn.getId() != null && btn.getId().contains(e.name())).findFirst().orElse(null);
    }
}

