/*
 * Decompiled with CFR 0.152.
 */
package com.github.ygimenez.listener;

import com.github.ygimenez.method.Pages;
import com.github.ygimenez.model.ActionReference;
import com.github.ygimenez.model.PUtilsConfig;
import com.github.ygimenez.model.PaginationEventWrapper;
import com.github.ygimenez.model.ThrowingBiConsumer;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.zip.CRC32;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.User;
import net.dv8tion.jda.api.entities.channel.middleman.MessageChannel;
import net.dv8tion.jda.api.events.interaction.component.ButtonInteractionEvent;
import net.dv8tion.jda.api.events.interaction.component.GenericSelectMenuInteractionEvent;
import net.dv8tion.jda.api.events.message.GenericMessageEvent;
import net.dv8tion.jda.api.events.message.MessageDeleteEvent;
import net.dv8tion.jda.api.events.message.react.GenericMessageReactionEvent;
import net.dv8tion.jda.api.events.message.react.MessageReactionAddEvent;
import net.dv8tion.jda.api.events.message.react.MessageReactionRemoveEvent;
import net.dv8tion.jda.api.hooks.ListenerAdapter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EventHandler
extends ListenerAdapter {
    private final Map<String, ThrowingBiConsumer<User, PaginationEventWrapper>> events = new ConcurrentHashMap<String, ThrowingBiConsumer<User, PaginationEventWrapper>>();
    private final Map<String, Map<String, List<?>>> dropdownValues = new ConcurrentHashMap();
    private final Set<String> locks = ConcurrentHashMap.newKeySet();
    private final CRC32 crc = new CRC32();

    public ActionReference addEvent(@NotNull Message msg, @NotNull ThrowingBiConsumer<User, PaginationEventWrapper> act) {
        String id = this.getEventId(msg);
        Pages.getPaginator().log(PUtilsConfig.LogLevel.LEVEL_3, "Added event with ID " + id + " and Consumer hash " + Integer.toHexString(act.hashCode()));
        this.events.put(id, act);
        return new ActionReference(id);
    }

    public void removeEvent(@NotNull Message msg) {
        String id = this.getEventId(msg);
        Pages.getPaginator().log(PUtilsConfig.LogLevel.LEVEL_3, "Removed event with ID " + id);
        this.events.remove(id);
        this.dropdownValues.remove(id);
    }

    public boolean checkEvent(@Nullable String hash) {
        if (hash == null) {
            return false;
        }
        return this.events.containsKey(hash);
    }

    public Map<String, ThrowingBiConsumer<User, PaginationEventWrapper>> getEventMap() {
        return Collections.unmodifiableMap(this.events);
    }

    public void clear() {
        Pages.getPaginator().log(PUtilsConfig.LogLevel.LEVEL_3, "Cleared all active events");
        this.events.clear();
        this.dropdownValues.clear();
    }

    private synchronized void lock(@NotNull String id) {
        Pages.getPaginator().log(PUtilsConfig.LogLevel.LEVEL_4, "Locked event with ID " + id);
        this.locks.add(id);
    }

    private synchronized void unlock(@NotNull String id) {
        Pages.getPaginator().log(PUtilsConfig.LogLevel.LEVEL_4, "Unlocked event with ID " + id);
        this.locks.remove(id);
    }

    private synchronized boolean isLocked(@NotNull String id) {
        return this.locks.contains(id);
    }

    public void onMessageReactionAdd(@NotNull MessageReactionAddEvent evt) {
        this.execute((GenericMessageReactionEvent)evt);
    }

    public void onMessageReactionRemove(@NotNull MessageReactionRemoveEvent evt) {
        if (!Pages.getPaginator().isRemoveOnReact() || !evt.isFromGuild()) {
            this.execute((GenericMessageReactionEvent)evt);
        }
    }

    public void onMessageDelete(@NotNull MessageDeleteEvent evt) {
        this.events.remove(this.getEventId((GenericMessageEvent)evt));
    }

    private void execute(GenericMessageReactionEvent evt) {
        String id = this.getEventId((GenericMessageEvent)evt);
        Pages.getPaginator().log(PUtilsConfig.LogLevel.LEVEL_4, "Received reaction event with ID " + id);
        if (!this.events.containsKey(id)) {
            Pages.getPaginator().log(PUtilsConfig.LogLevel.LEVEL_4, "Event not mapped, skipping");
            return;
        }
        evt.retrieveMessage().submit().whenComplete((m, t) -> evt.retrieveUser().submit().whenComplete((u, thr) -> this.processEvent((Throwable)t, id, (User)u, new PaginationEventWrapper(evt, (User)u, (MessageChannel)evt.getChannel(), (Message)m, evt.getReaction(), evt.isFromGuild()))));
    }

    public void onButtonInteraction(@NotNull ButtonInteractionEvent evt) {
        String id = this.getEventId(evt);
        Pages.getPaginator().log(PUtilsConfig.LogLevel.LEVEL_4, "Received button event with ID " + id);
        if (!this.events.containsKey(id)) {
            evt.deferEdit().submit().whenComplete((hook, t) -> Pages.getPaginator().getOnRemove().accept(evt.getHook()));
            Pages.getPaginator().log(PUtilsConfig.LogLevel.LEVEL_4, "Event not mapped, skipping");
            return;
        }
        evt.deferEdit().submit().whenComplete((hook, t) -> {
            User u = hook.getInteraction().getUser();
            this.processEvent((Throwable)t, id, u, new PaginationEventWrapper(evt, u, (MessageChannel)evt.getChannel(), evt.getMessage(), evt.getButton(), evt.isFromGuild()));
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processEvent(Throwable t, String id, User u, PaginationEventWrapper evt) {
        if (t != null) {
            Pages.getPaginator().log(PUtilsConfig.LogLevel.LEVEL_1, "An error occurred when processing event with ID " + id, t);
            return;
        }
        if (u.isBot() || this.isLocked(id)) {
            Pages.getPaginator().log(PUtilsConfig.LogLevel.LEVEL_4, "Event" + id + " was triggered by a bot or is locked. Ignored");
            return;
        }
        try {
            if (Pages.getPaginator().isEventLocked()) {
                this.lock(id);
            }
            Pages.getPaginator().log(PUtilsConfig.LogLevel.LEVEL_4, "Searching for action for event with ID " + id);
            ThrowingBiConsumer<User, PaginationEventWrapper> act = this.events.get(id);
            if (act != null) {
                Pages.getPaginator().log(PUtilsConfig.LogLevel.LEVEL_4, "Action found");
                act.accept(u, evt);
            } else {
                Pages.getPaginator().log(PUtilsConfig.LogLevel.LEVEL_4, "Action not found");
            }
        }
        catch (RuntimeException e) {
            Pages.getPaginator().log(PUtilsConfig.LogLevel.LEVEL_1, "An error occurred when processing event with ID " + id, e);
        }
        finally {
            if (Pages.getPaginator().isEventLocked()) {
                this.unlock(id);
            }
        }
    }

    public void onGenericSelectMenuInteraction(@NotNull GenericSelectMenuInteractionEvent evt) {
        String id = this.getEventId(evt.getMessage());
        Pages.getPaginator().log(PUtilsConfig.LogLevel.LEVEL_4, "Received dropdown values for event with ID " + id);
        if (!this.events.containsKey(id)) {
            evt.deferEdit().submit().whenComplete((hook, t) -> Pages.getPaginator().getOnRemove().accept(evt.getHook()));
            Pages.getPaginator().log(PUtilsConfig.LogLevel.LEVEL_4, "Event not mapped, skipping");
            return;
        }
        evt.deferEdit().submit().whenComplete((hook, t) -> this.dropdownValues.computeIfAbsent(id, k -> new HashMap()).put(evt.getComponentId(), evt.getValues()));
    }

    public Map<String, List<?>> getDropdownValues(String eventId) {
        if (!this.events.containsKey(eventId)) {
            return null;
        }
        return this.dropdownValues.computeIfAbsent(eventId, k -> new HashMap());
    }

    public String getEventId(Message msg) {
        this.crc.reset();
        String rawId = (msg.isFromGuild() ? "GUILD_" : "PRIVATE_") + msg.getChannel().getId() + "_" + msg.getId();
        this.crc.update(rawId.getBytes(StandardCharsets.UTF_8));
        return Long.toHexString(this.crc.getValue());
    }

    private String getEventId(GenericMessageEvent evt) {
        this.crc.reset();
        String rawId = (evt.isFromGuild() ? "GUILD_" : "PRIVATE_") + evt.getChannel().getId() + "_" + evt.getMessageId();
        this.crc.update(rawId.getBytes(StandardCharsets.UTF_8));
        return Long.toHexString(this.crc.getValue());
    }

    private String getEventId(ButtonInteractionEvent evt) {
        this.crc.reset();
        String rawId = (evt.isFromGuild() ? "GUILD_" : "PRIVATE_") + evt.getChannel().getId() + "_" + evt.getMessageId();
        this.crc.update(rawId.getBytes(StandardCharsets.UTF_8));
        return Long.toHexString(this.crc.getValue());
    }
}

