/*
 * Decompiled with CFR 0.152.
 */
package com.github.ygimenez.method;

import com.github.ygimenez.exception.AlreadyActivatedException;
import com.github.ygimenez.exception.InvalidHandlerException;
import com.github.ygimenez.exception.InvalidStateException;
import com.github.ygimenez.listener.EventHandler;
import com.github.ygimenez.model.ActionReference;
import com.github.ygimenez.model.ButtonWrapper;
import com.github.ygimenez.model.EmbedCluster;
import com.github.ygimenez.model.PUtilsConfig;
import com.github.ygimenez.model.Page;
import com.github.ygimenez.model.PaginationEventWrapper;
import com.github.ygimenez.model.Paginator;
import com.github.ygimenez.model.ThrowingBiConsumer;
import com.github.ygimenez.model.ThrowingConsumer;
import com.github.ygimenez.model.ThrowingFunction;
import com.github.ygimenez.model.helper.ButtonizeHelper;
import com.github.ygimenez.model.helper.CategorizeHelper;
import com.github.ygimenez.model.helper.LazyPaginateHelper;
import com.github.ygimenez.model.helper.PaginateHelper;
import com.github.ygimenez.type.Emote;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.dv8tion.jda.api.JDA;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.MessageEmbed;
import net.dv8tion.jda.api.entities.MessageReaction;
import net.dv8tion.jda.api.entities.User;
import net.dv8tion.jda.api.entities.emoji.CustomEmoji;
import net.dv8tion.jda.api.entities.emoji.Emoji;
import net.dv8tion.jda.api.entities.emoji.EmojiUnion;
import net.dv8tion.jda.api.events.interaction.component.ButtonInteractionEvent;
import net.dv8tion.jda.api.events.message.react.MessageReactionAddEvent;
import net.dv8tion.jda.api.exceptions.ErrorResponseException;
import net.dv8tion.jda.api.exceptions.InsufficientPermissionException;
import net.dv8tion.jda.api.interactions.InteractionHook;
import net.dv8tion.jda.api.interactions.components.ItemComponent;
import net.dv8tion.jda.api.interactions.components.LayoutComponent;
import net.dv8tion.jda.api.interactions.components.buttons.Button;
import net.dv8tion.jda.api.requests.RestAction;
import net.dv8tion.jda.api.requests.restaction.MessageEditAction;
import net.dv8tion.jda.api.sharding.ShardManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Pages {
    private static final ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
    private static final EventHandler handler = new EventHandler();
    private static Paginator paginator;

    private Pages() {
    }

    public static void activate(@NotNull Paginator paginator) throws InvalidHandlerException {
        if (Pages.isActivated()) {
            throw new AlreadyActivatedException();
        }
        Object hand = paginator.getHandler();
        if (hand instanceof JDA) {
            ((JDA)hand).addEventListener(new Object[]{handler});
        } else if (hand instanceof ShardManager) {
            ((ShardManager)hand).addEventListener(new Object[]{handler});
        } else {
            throw new InvalidHandlerException();
        }
        Pages.paginator = paginator;
        paginator.log(PUtilsConfig.LogLevel.LEVEL_2, "Pagination Utils activated successfully");
    }

    public static void deactivate() {
        if (!Pages.isActivated()) {
            return;
        }
        Object hand = paginator.getHandler();
        if (hand instanceof JDA) {
            ((JDA)hand).removeEventListener(new Object[]{handler});
        } else if (hand instanceof ShardManager) {
            ((ShardManager)hand).removeEventListener(new Object[]{handler});
        }
        paginator.log(PUtilsConfig.LogLevel.LEVEL_2, "Pagination Utils deactivated successfully");
        paginator = null;
    }

    public static boolean isActivated() {
        return paginator != null && paginator.getHandler() != null;
    }

    public static Paginator getPaginator() {
        return paginator;
    }

    public static EventHandler getHandler() {
        return handler;
    }

    public static ActionReference paginate(@NotNull Message msg, @NotNull List<Page> pages, boolean useButtons) throws ErrorResponseException, InsufficientPermissionException {
        return Pages.paginate(msg, pages, useButtons, 0, null, 0, false, null);
    }

    public static ActionReference paginate(@NotNull Message msg, @NotNull List<Page> pages, boolean useButtons, int time, TimeUnit unit) throws ErrorResponseException, InsufficientPermissionException {
        return Pages.paginate(msg, pages, useButtons, time, unit, 0, false, null);
    }

    public static ActionReference paginate(@NotNull Message msg, @NotNull List<Page> pages, boolean useButtons, Predicate<User> canInteract) throws ErrorResponseException, InsufficientPermissionException {
        return Pages.paginate(msg, pages, useButtons, 0, null, 0, false, canInteract);
    }

    public static ActionReference paginate(@NotNull Message msg, @NotNull List<Page> pages, boolean useButtons, int time, TimeUnit unit, Predicate<User> canInteract) throws ErrorResponseException, InsufficientPermissionException {
        return Pages.paginate(msg, pages, useButtons, time, unit, 0, false, canInteract);
    }

    public static ActionReference paginate(@NotNull Message msg, @NotNull List<Page> pages, boolean useButtons, boolean fastForward) throws ErrorResponseException, InsufficientPermissionException {
        return Pages.paginate(msg, pages, useButtons, 0, null, 0, fastForward, null);
    }

    public static ActionReference paginate(@NotNull Message msg, @NotNull List<Page> pages, boolean useButtons, int time, TimeUnit unit, boolean fastForward) throws ErrorResponseException, InsufficientPermissionException {
        return Pages.paginate(msg, pages, useButtons, time, unit, 0, fastForward, null);
    }

    public static ActionReference paginate(@NotNull Message msg, @NotNull List<Page> pages, boolean useButtons, boolean fastForward, Predicate<User> canInteract) throws ErrorResponseException, InsufficientPermissionException {
        return Pages.paginate(msg, pages, useButtons, 0, null, 0, fastForward, canInteract);
    }

    public static ActionReference paginate(@NotNull Message msg, @NotNull List<Page> pages, boolean useButtons, int time, TimeUnit unit, boolean fastForward, Predicate<User> canInteract) throws ErrorResponseException, InsufficientPermissionException {
        return Pages.paginate(msg, pages, useButtons, time, unit, 0, fastForward, canInteract);
    }

    public static ActionReference paginate(@NotNull Message msg, @NotNull List<Page> pages, boolean useButtons, int skipAmount) throws ErrorResponseException, InsufficientPermissionException {
        return Pages.paginate(msg, pages, useButtons, 0, null, skipAmount, false, null);
    }

    public static ActionReference paginate(@NotNull Message msg, @NotNull List<Page> pages, boolean useButtons, int time, TimeUnit unit, int skipAmount) throws ErrorResponseException, InsufficientPermissionException {
        return Pages.paginate(msg, pages, useButtons, time, unit, skipAmount, false, null);
    }

    public static ActionReference paginate(@NotNull Message msg, @NotNull List<Page> pages, boolean useButtons, int skipAmount, Predicate<User> canInteract) throws ErrorResponseException, InsufficientPermissionException {
        return Pages.paginate(msg, pages, useButtons, 0, null, skipAmount, false, canInteract);
    }

    public static ActionReference paginate(@NotNull Message msg, @NotNull List<Page> pages, boolean useButtons, int time, TimeUnit unit, int skipAmount, Predicate<User> canInteract) throws ErrorResponseException, InsufficientPermissionException {
        return Pages.paginate(msg, pages, useButtons, time, unit, skipAmount, false, canInteract);
    }

    public static ActionReference paginate(@NotNull Message msg, @NotNull List<Page> pages, boolean useButtons, int skipAmount, boolean fastForward, Predicate<User> canInteract) throws ErrorResponseException, InsufficientPermissionException {
        return Pages.paginate(msg, pages, useButtons, 0, null, skipAmount, fastForward, canInteract);
    }

    public static ActionReference paginate(@NotNull Message msg, @NotNull List<Page> pages, boolean useButtons, int time, TimeUnit unit, int skipAmount, boolean fastForward) throws ErrorResponseException, InsufficientPermissionException {
        return Pages.paginate(msg, pages, useButtons, time, unit, skipAmount, fastForward, null);
    }

    public static ActionReference paginate(@NotNull Message msg, @NotNull List<Page> pages, boolean useButtons, int time, TimeUnit unit, int skipAmount, boolean fastForward, Predicate<User> canInteract) throws ErrorResponseException, InsufficientPermissionException {
        return Pages.paginate(msg, (PaginateHelper)((PaginateHelper)new PaginateHelper(pages, useButtons).setTimeout(time, unit)).setSkipAmount(skipAmount).setFastForward(fastForward).setCanInteract(canInteract));
    }

    public static ActionReference paginate(final @NotNull Message msg, final @NotNull PaginateHelper helper) throws ErrorResponseException, InsufficientPermissionException {
        if (!Pages.isActivated() || ((List)helper.getContent()).isEmpty()) {
            throw new InvalidStateException();
        }
        boolean useBtns = helper.isUsingButtons() && msg.getAuthor().getId().equals(msg.getJDA().getSelfUser().getId());
        final List pgs = Collections.unmodifiableList((List)helper.getContent());
        if (useBtns && helper.shouldUpdate(msg)) {
            helper.apply(msg.editMessageComponents(new LayoutComponent[0])).submit();
        } else if (!useBtns) {
            Pages.clearButtons(msg);
            Pages.clearReactions(msg);
            Pages.addReactions(msg, helper.getSkipAmount() > 1, helper.isFastForward());
        }
        return handler.addEvent(msg, new ThrowingBiConsumer<User, PaginationEventWrapper>(){
            private final int maxP;
            private int p;
            private ScheduledFuture<?> timeout;
            private final Consumer<Void> success;
            private final Function<Button, Button> LOWER_BOUNDARY_CHECK;
            private final Function<Button, Button> UPPER_BOUNDARY_CHECK;
            {
                this.maxP = pgs.size() - 1;
                this.p = 0;
                this.success = s -> {
                    if (this.timeout != null) {
                        this.timeout.cancel(true);
                    }
                    handler.removeEvent(msg);
                    if (paginator.isDeleteOnCancel()) {
                        msg.delete().submit();
                    }
                };
                this.LOWER_BOUNDARY_CHECK = b -> b.withDisabled(this.p == 0);
                this.UPPER_BOUNDARY_CHECK = b -> b.withDisabled(this.p == this.maxP);
                if (helper.getTimeout() > 0L) {
                    this.timeout = executor.schedule(() -> Pages.finalizeEvent(msg, this.success), helper.getTimeout(), TimeUnit.MILLISECONDS);
                }
            }

            @Override
            public void acceptThrows(@NotNull User u, @NotNull PaginationEventWrapper wrapper) {
                Message m = wrapper.retrieveMessage();
                if (helper.canInteract(u)) {
                    Button btn;
                    if (u.isBot() || m == null || !wrapper.getMessageId().equals(msg.getId())) {
                        return;
                    }
                    Emote emt = Emote.NONE;
                    if (wrapper.getContent() instanceof MessageReaction) {
                        EmojiUnion reaction = ((MessageReaction)wrapper.getContent()).getEmoji();
                        emt = Pages.toEmote(reaction);
                    } else if (wrapper.getContent() instanceof Button && (btn = (Button)wrapper.getContent()).getId() != null && Emote.isNative(btn) && !btn.getId().contains(".")) {
                        emt = Emote.valueOf(btn.getId().replace("*", ""));
                    }
                    boolean update = false;
                    switch (emt) {
                        case PREVIOUS: {
                            if (this.p <= 0) break;
                            --this.p;
                            update = true;
                            break;
                        }
                        case NEXT: {
                            if (this.p >= this.maxP) break;
                            ++this.p;
                            update = true;
                            break;
                        }
                        case SKIP_BACKWARD: {
                            if (this.p <= 0) break;
                            this.p -= this.p - helper.getSkipAmount() < 0 ? this.p : helper.getSkipAmount();
                            update = true;
                            break;
                        }
                        case SKIP_FORWARD: {
                            if (this.p >= this.maxP) break;
                            this.p += this.p + helper.getSkipAmount() > this.maxP ? this.maxP - this.p : helper.getSkipAmount();
                            update = true;
                            break;
                        }
                        case GOTO_FIRST: {
                            if (this.p <= 0) break;
                            this.p = 0;
                            update = true;
                            break;
                        }
                        case GOTO_LAST: {
                            if (this.p >= this.maxP) break;
                            this.p = this.maxP;
                            update = true;
                            break;
                        }
                        case CANCEL: {
                            if (m.isEphemeral() && wrapper.getHook() != null) {
                                Pages.finalizeEvent(wrapper.getHook(), this.success);
                            } else {
                                Pages.finalizeEvent(m, this.success);
                            }
                            return;
                        }
                    }
                    if (update) {
                        Page pg = (Page)pgs.get(this.p);
                        Pages.modifyButtons(m, pg, Map.of(Emote.PREVIOUS.name(), this.LOWER_BOUNDARY_CHECK, Emote.SKIP_BACKWARD.name(), this.LOWER_BOUNDARY_CHECK, Emote.GOTO_FIRST.name(), this.LOWER_BOUNDARY_CHECK, Emote.NEXT.name(), this.UPPER_BOUNDARY_CHECK, Emote.SKIP_FORWARD.name(), this.UPPER_BOUNDARY_CHECK, Emote.GOTO_LAST.name(), this.UPPER_BOUNDARY_CHECK));
                    }
                    if (this.timeout != null) {
                        this.timeout.cancel(true);
                    }
                    if (helper.getTimeout() > 0L) {
                        this.timeout = executor.schedule(() -> Pages.finalizeEvent(m, this.success), helper.getTimeout(), TimeUnit.MILLISECONDS);
                    }
                    if (wrapper.isFromGuild() && wrapper.getSource() instanceof MessageReactionAddEvent && paginator.isRemoveOnReact()) {
                        Pages.subGet(((MessageReaction)wrapper.getContent()).removeReaction(u));
                    }
                }
            }
        });
    }

    public static ActionReference categorize(@NotNull Message msg, @NotNull Map<Emoji, Page> categories, boolean useButtons) throws ErrorResponseException, InsufficientPermissionException {
        return Pages.categorize(msg, categories, useButtons, 0, null, null);
    }

    public static ActionReference categorize(@NotNull Message msg, @NotNull Map<Emoji, Page> categories, boolean useButtons, int time, TimeUnit unit) throws ErrorResponseException, InsufficientPermissionException {
        return Pages.categorize(msg, categories, useButtons, time, unit, null);
    }

    public static ActionReference categorize(@NotNull Message msg, @NotNull Map<Emoji, Page> categories, boolean useButtons, Predicate<User> canInteract) throws ErrorResponseException, InsufficientPermissionException {
        return Pages.categorize(msg, categories, useButtons, 0, null, canInteract);
    }

    public static ActionReference categorize(@NotNull Message msg, @NotNull Map<Emoji, Page> categories, boolean useButtons, int time, TimeUnit unit, Predicate<User> canInteract) throws ErrorResponseException, InsufficientPermissionException {
        return Pages.categorize(msg, (CategorizeHelper)((CategorizeHelper)new CategorizeHelper(categories, useButtons).setTimeout(time, unit)).setCanInteract(canInteract));
    }

    public static ActionReference categorize(final @NotNull Message msg, final @NotNull CategorizeHelper helper) throws ErrorResponseException, InsufficientPermissionException {
        if (!Pages.isActivated()) {
            throw new InvalidStateException();
        }
        boolean useBtns = helper.isUsingButtons() && msg.getAuthor().getId().equals(msg.getJDA().getSelfUser().getId());
        final Map cats = Collections.unmodifiableMap((Map)helper.getContent());
        if (useBtns && helper.shouldUpdate(msg)) {
            helper.apply(msg.editMessageComponents(new LayoutComponent[0])).submit();
        } else if (!useBtns) {
            Pages.clearButtons(msg);
            Pages.clearReactions(msg);
            for (Emoji k : cats.keySet()) {
                msg.addReaction(k).submit();
            }
            msg.addReaction(paginator.getEmoji(Emote.CANCEL)).submit();
        }
        return handler.addEvent(msg, new ThrowingBiConsumer<User, PaginationEventWrapper>(){
            private Emoji currCat = null;
            private ScheduledFuture<?> timeout;
            private final Consumer<Void> success = s -> {
                if (this.timeout != null) {
                    this.timeout.cancel(true);
                }
                handler.removeEvent(msg);
                if (paginator.isDeleteOnCancel()) {
                    msg.delete().submit();
                }
            };
            {
                if (helper.getTimeout() > 0L) {
                    this.timeout = executor.schedule(() -> Pages.finalizeEvent(msg, this.success), helper.getTimeout(), TimeUnit.MILLISECONDS);
                }
            }

            @Override
            public void acceptThrows(@NotNull User u, @NotNull PaginationEventWrapper wrapper) {
                Message m = wrapper.retrieveMessage();
                if (helper.canInteract(u)) {
                    Page pg;
                    if (u.isBot() || m == null || !wrapper.getMessageId().equals(msg.getId())) {
                        return;
                    }
                    Emoji emoji = null;
                    Emote emt = Emote.NONE;
                    if (wrapper.getContent() instanceof MessageReaction) {
                        EmojiUnion reaction = ((MessageReaction)wrapper.getContent()).getEmoji();
                        emoji = Pages.toEmoji(reaction);
                        emt = Pages.toEmote(reaction);
                    } else if (wrapper.getContent() instanceof Button) {
                        Button btn = (Button)wrapper.getContent();
                        emoji = btn.getEmoji();
                        if (btn.getId() != null && Emote.isNative(btn) && !btn.getId().contains(".")) {
                            emt = Emote.valueOf(btn.getId().replace("*", ""));
                        }
                    }
                    if (emt == Emote.CANCEL) {
                        if (m.isEphemeral() && wrapper.getHook() != null) {
                            Pages.finalizeEvent(wrapper.getHook(), this.success);
                        } else {
                            Pages.finalizeEvent(m, this.success);
                        }
                        return;
                    }
                    if (emoji != null && !Objects.equals(emoji, this.currCat) && (pg = (Page)Pages.lookupValue(cats, emoji)) != null) {
                        this.currCat = emoji;
                        Pages.modifyButtons(m, pg, Map.of(Emote.getId(this.currCat), Button::asDisabled, "default", Button::asEnabled));
                    }
                    if (this.timeout != null) {
                        this.timeout.cancel(true);
                    }
                    if (helper.getTimeout() > 0L) {
                        this.timeout = executor.schedule(() -> Pages.finalizeEvent(msg, this.success), helper.getTimeout(), TimeUnit.MILLISECONDS);
                    }
                    if (wrapper.isFromGuild() && wrapper.getSource() instanceof MessageReactionAddEvent && paginator.isRemoveOnReact()) {
                        Pages.subGet(((MessageReaction)wrapper.getContent()).removeReaction(u));
                    }
                }
            }
        });
    }

    public static ActionReference buttonize(@NotNull Message msg, @NotNull Map<Emoji, ThrowingConsumer<ButtonWrapper>> buttons, boolean useButtons, boolean showCancelButton) throws ErrorResponseException, InsufficientPermissionException {
        return Pages.buttonize(msg, buttons, useButtons, showCancelButton, 0, null, null, null);
    }

    public static ActionReference buttonize(@NotNull Message msg, @NotNull Map<Emoji, ThrowingConsumer<ButtonWrapper>> buttons, boolean useButtons, boolean showCancelButton, int time, TimeUnit unit) throws ErrorResponseException, InsufficientPermissionException {
        return Pages.buttonize(msg, buttons, useButtons, showCancelButton, time, unit, null, null);
    }

    public static ActionReference buttonize(@NotNull Message msg, @NotNull Map<Emoji, ThrowingConsumer<ButtonWrapper>> buttons, boolean useButtons, boolean showCancelButton, Predicate<User> canInteract) throws ErrorResponseException, InsufficientPermissionException {
        return Pages.buttonize(msg, buttons, useButtons, showCancelButton, 0, null, canInteract, null);
    }

    public static ActionReference buttonize(@NotNull Message msg, @NotNull Map<Emoji, ThrowingConsumer<ButtonWrapper>> buttons, boolean useButtons, boolean showCancelButton, int time, TimeUnit unit, Predicate<User> canInteract) throws ErrorResponseException, InsufficientPermissionException {
        return Pages.buttonize(msg, buttons, useButtons, showCancelButton, time, unit, canInteract, null);
    }

    public static ActionReference buttonize(@NotNull Message msg, @NotNull Map<Emoji, ThrowingConsumer<ButtonWrapper>> buttons, boolean useButtons, boolean showCancelButton, Predicate<User> canInteract, Consumer<Message> onCancel) throws ErrorResponseException, InsufficientPermissionException {
        return Pages.buttonize(msg, buttons, useButtons, showCancelButton, 0, null, canInteract, onCancel);
    }

    public static ActionReference buttonize(@NotNull Message msg, @NotNull Map<Emoji, ThrowingConsumer<ButtonWrapper>> buttons, boolean useButtons, boolean cancellable, int time, TimeUnit unit, Predicate<User> canInteract, Consumer<Message> onCancel) throws ErrorResponseException, InsufficientPermissionException {
        return Pages.buttonize(msg, ((ButtonizeHelper)((ButtonizeHelper)((ButtonizeHelper)new ButtonizeHelper(buttons, useButtons).setCancellable(cancellable)).setTimeout(time, unit)).setCanInteract(canInteract)).setOnFinalization(onCancel));
    }

    public static ActionReference buttonize(final @NotNull Message msg, final @NotNull ButtonizeHelper helper) throws ErrorResponseException, InsufficientPermissionException {
        if (!Pages.isActivated()) {
            throw new InvalidStateException();
        }
        boolean useBtns = helper.isUsingButtons() && msg.getAuthor().getId().equals(msg.getJDA().getSelfUser().getId());
        final Map btns = Collections.unmodifiableMap((Map)helper.getContent());
        if (useBtns && helper.shouldUpdate(msg)) {
            helper.apply(msg.editMessageComponents(new LayoutComponent[0])).submit();
        } else if (!useBtns) {
            Pages.clearButtons(msg);
            Pages.clearReactions(msg);
            for (Emoji k : btns.keySet()) {
                msg.addReaction(k).submit();
            }
            if (!btns.containsKey(paginator.getEmoji(Emote.CANCEL)) && helper.isCancellable()) {
                msg.addReaction(paginator.getEmoji(Emote.CANCEL)).submit();
            }
        }
        return handler.addEvent(msg, new ThrowingBiConsumer<User, PaginationEventWrapper>(){
            private ScheduledFuture<?> timeout;
            private final Consumer<Void> success = s -> {
                if (this.timeout != null) {
                    this.timeout.cancel(true);
                }
                handler.removeEvent(msg);
                if (helper.getOnFinalization() != null) {
                    helper.getOnFinalization().accept(msg);
                }
                if (paginator.isDeleteOnCancel()) {
                    msg.delete().submit();
                }
            };
            {
                if (helper.getTimeout() > 0L) {
                    this.timeout = executor.schedule(() -> Pages.finalizeEvent(msg, this.success), helper.getTimeout(), TimeUnit.MILLISECONDS);
                }
            }

            @Override
            public void acceptThrows(@NotNull User u, @NotNull PaginationEventWrapper wrapper) {
                Message m = wrapper.retrieveMessage();
                if (helper.canInteract(u)) {
                    InteractionHook hook;
                    Button button;
                    if (u.isBot() || m == null || !wrapper.getMessageId().equals(msg.getId())) {
                        return;
                    }
                    Emoji emoji = null;
                    Emote emt = Emote.NONE;
                    if (wrapper.getContent() instanceof MessageReaction) {
                        EmojiUnion reaction = ((MessageReaction)wrapper.getContent()).getEmoji();
                        emoji = Pages.toEmoji(reaction);
                        emt = Pages.toEmote(reaction);
                    } else if (wrapper.getContent() instanceof Button) {
                        Button btn = (Button)wrapper.getContent();
                        emoji = btn.getEmoji();
                        if (btn.getId() != null && Emote.isNative(btn) && !btn.getId().contains(".")) {
                            emt = Emote.valueOf(btn.getId().replace("*", ""));
                        }
                    }
                    if (!btns.containsKey(paginator.getEmoji(Emote.CANCEL)) && helper.isCancellable() && emt == Emote.CANCEL) {
                        if (m.isEphemeral() && wrapper.getHook() != null) {
                            Pages.finalizeEvent(wrapper.getHook(), this.success);
                        } else {
                            Pages.finalizeEvent(m, this.success);
                        }
                        return;
                    }
                    if (wrapper.getSource() instanceof ButtonInteractionEvent) {
                        button = (Button)wrapper.getContent();
                        hook = ((ButtonInteractionEvent)wrapper.getSource()).getHook();
                    } else {
                        button = null;
                        hook = null;
                    }
                    ThrowingConsumer act = (ThrowingConsumer)Pages.lookupValue(btns, emoji);
                    if (act != null) {
                        act.accept(new ButtonWrapper(wrapper.getUser(), hook, button, handler.getDropdownValues(handler.getEventId(m)), m));
                    }
                    if (this.timeout != null) {
                        this.timeout.cancel(true);
                    }
                    if (helper.getTimeout() > 0L) {
                        this.timeout = executor.schedule(() -> Pages.finalizeEvent(msg, this.success), helper.getTimeout(), TimeUnit.MILLISECONDS);
                    }
                    if (wrapper.isFromGuild() && wrapper.getSource() instanceof MessageReactionAddEvent && paginator.isRemoveOnReact()) {
                        Pages.subGet(((MessageReaction)wrapper.getContent()).removeReaction(u));
                    }
                }
            }
        });
    }

    public static ActionReference lazyPaginate(@NotNull Message msg, @NotNull ThrowingFunction<Integer, Page> pageLoader, boolean useButtons) throws ErrorResponseException, InsufficientPermissionException {
        return Pages.lazyPaginate(msg, null, pageLoader, useButtons, 0, null, null);
    }

    public static ActionReference lazyPaginate(@NotNull Message msg, @NotNull ThrowingFunction<Integer, Page> pageLoader, boolean useButtons, int time, TimeUnit unit) throws ErrorResponseException, InsufficientPermissionException {
        return Pages.lazyPaginate(msg, null, pageLoader, useButtons, time, unit, null);
    }

    public static ActionReference lazyPaginate(@NotNull Message msg, @NotNull ThrowingFunction<Integer, Page> pageLoader, boolean useButtons, Predicate<User> canInteract) throws ErrorResponseException, InsufficientPermissionException {
        return Pages.lazyPaginate(msg, null, pageLoader, useButtons, 0, null, canInteract);
    }

    public static ActionReference lazyPaginate(@NotNull Message msg, @NotNull ThrowingFunction<Integer, Page> pageLoader, boolean useButtons, int time, TimeUnit unit, Predicate<User> canInteract) throws ErrorResponseException, InsufficientPermissionException {
        return Pages.lazyPaginate(msg, null, pageLoader, useButtons, time, unit, canInteract);
    }

    public static ActionReference lazyPaginate(@NotNull Message msg, List<Page> pageCache, @NotNull ThrowingFunction<Integer, Page> pageLoader, boolean useButtons) throws ErrorResponseException, InsufficientPermissionException {
        return Pages.lazyPaginate(msg, pageCache, pageLoader, useButtons, 0, null, null);
    }

    public static ActionReference lazyPaginate(@NotNull Message msg, List<Page> pageCache, @NotNull ThrowingFunction<Integer, Page> pageLoader, boolean useButtons, int time, TimeUnit unit) throws ErrorResponseException, InsufficientPermissionException {
        return Pages.lazyPaginate(msg, pageCache, pageLoader, useButtons, time, unit, null);
    }

    public static ActionReference lazyPaginate(@NotNull Message msg, List<Page> pageCache, @NotNull ThrowingFunction<Integer, Page> pageLoader, boolean useButtons, Predicate<User> canInteract) throws ErrorResponseException, InsufficientPermissionException {
        return Pages.lazyPaginate(msg, pageCache, pageLoader, useButtons, 0, null, canInteract);
    }

    public static ActionReference lazyPaginate(@NotNull Message msg, List<Page> pageCache, @NotNull ThrowingFunction<Integer, Page> pageLoader, boolean useButtons, int time, TimeUnit unit, Predicate<User> canInteract) throws ErrorResponseException, InsufficientPermissionException {
        return Pages.lazyPaginate(msg, (LazyPaginateHelper)((LazyPaginateHelper)new LazyPaginateHelper(pageLoader, pageCache, useButtons).setTimeout(time, unit)).setCanInteract(canInteract));
    }

    public static ActionReference lazyPaginate(final @NotNull Message msg, final @NotNull LazyPaginateHelper helper) throws ErrorResponseException, InsufficientPermissionException {
        boolean cache;
        if (!Pages.isActivated()) {
            throw new InvalidStateException();
        }
        boolean useBtns = helper.isUsingButtons() && msg.getAuthor().getId().equals(msg.getJDA().getSelfUser().getId());
        boolean bl = cache = helper.getContent() != null;
        if (useBtns && helper.shouldUpdate(msg)) {
            helper.apply(msg.editMessageComponents(new LayoutComponent[0])).submit();
        } else if (!useBtns) {
            Pages.clearButtons(msg);
            Pages.clearReactions(msg);
            Pages.addReactions(msg, false, false);
        }
        return handler.addEvent(msg, new ThrowingBiConsumer<User, PaginationEventWrapper>(){
            private int p = 0;
            private ScheduledFuture<?> timeout;
            private final Consumer<Void> success = s -> {
                if (this.timeout != null) {
                    this.timeout.cancel(true);
                }
                handler.removeEvent(msg);
                if (paginator.isDeleteOnCancel()) {
                    msg.delete().submit();
                }
            };
            private final Function<Button, Button> LOWER_BOUNDARY_CHECK = b -> b.withDisabled(this.p == 0);
            {
                if (helper.getTimeout() > 0L) {
                    this.timeout = executor.schedule(() -> Pages.finalizeEvent(msg, this.success), helper.getTimeout(), TimeUnit.MILLISECONDS);
                }
            }

            @Override
            public void acceptThrows(@NotNull User u, @NotNull PaginationEventWrapper wrapper) {
                Message m = wrapper.retrieveMessage();
                if (helper.canInteract(u)) {
                    Button btn;
                    if (u.isBot() || m == null || !wrapper.getMessageId().equals(msg.getId())) {
                        return;
                    }
                    Emote emt = Emote.NONE;
                    if (wrapper.getContent() instanceof MessageReaction) {
                        EmojiUnion reaction = ((MessageReaction)wrapper.getContent()).getEmoji();
                        emt = Pages.toEmote(reaction);
                    } else if (wrapper.getContent() instanceof Button && (btn = (Button)wrapper.getContent()).getId() != null && Emote.isNative(btn) && !btn.getId().contains(".")) {
                        emt = Emote.valueOf(btn.getId().replace("*", ""));
                    }
                    Page pg = null;
                    boolean update = false;
                    switch (emt) {
                        case PREVIOUS: {
                            if (this.p <= 0) break;
                            --this.p;
                            update = true;
                            pg = cache ? (Page)((List)helper.getContent()).get(this.p) : helper.getPageLoader().apply(this.p);
                            break;
                        }
                        case NEXT: {
                            ++this.p;
                            update = true;
                            if (cache && ((List)helper.getContent()).size() > this.p) {
                                pg = (Page)((List)helper.getContent()).get(this.p);
                                if (pg == null && (pg = helper.getPageLoader().apply(this.p)) == null) {
                                    --this.p;
                                    return;
                                }
                            } else {
                                pg = helper.getPageLoader().apply(this.p);
                                if (pg == null) {
                                    --this.p;
                                    return;
                                }
                            }
                            if (!cache) break;
                            ((List)helper.getContent()).add(pg);
                            break;
                        }
                        case CANCEL: {
                            if (m.isEphemeral() && wrapper.getHook() != null) {
                                Pages.finalizeEvent(wrapper.getHook(), this.success);
                            } else {
                                Pages.finalizeEvent(m, this.success);
                            }
                            return;
                        }
                    }
                    if (update) {
                        Pages.modifyButtons(m, pg, Map.of(Emote.PREVIOUS.name(), this.LOWER_BOUNDARY_CHECK, Emote.SKIP_BACKWARD.name(), this.LOWER_BOUNDARY_CHECK, Emote.GOTO_FIRST.name(), this.LOWER_BOUNDARY_CHECK));
                    }
                    if (this.timeout != null) {
                        this.timeout.cancel(true);
                    }
                    if (helper.getTimeout() > 0L) {
                        this.timeout = executor.schedule(() -> Pages.finalizeEvent(m, this.success), helper.getTimeout(), TimeUnit.MILLISECONDS);
                    }
                    if (wrapper.isFromGuild() && wrapper.getSource() instanceof MessageReactionAddEvent && paginator.isRemoveOnReact()) {
                        Pages.subGet(((MessageReaction)wrapper.getContent()).removeReaction(u));
                    }
                }
            }
        });
    }

    public static Message reloadMessage(@NotNull Message msg) {
        return Pages.subGet(msg.getChannel().retrieveMessageById(msg.getId()), msg);
    }

    public static <T> T subGet(@NotNull RestAction<T> future) {
        try {
            return future.submit().get();
        }
        catch (InterruptedException | ExecutionException e) {
            paginator.log(PUtilsConfig.LogLevel.LEVEL_4, "Exception during future execution:", e);
            return null;
        }
    }

    public static <T> T subGet(@NotNull RestAction<T> future, @NotNull T or) {
        try {
            return future.submit().get();
        }
        catch (InterruptedException | ExecutionException e) {
            paginator.log(PUtilsConfig.LogLevel.LEVEL_4, "Exception during future execution:", e);
            return or;
        }
    }

    private static Emote toEmote(EmojiUnion reaction) {
        return Emote.getByEmoji(Pages.toEmoji(reaction));
    }

    private static Emoji toEmoji(EmojiUnion reaction) {
        return Emoji.fromFormatted((String)reaction.getFormatted());
    }

    private static <T> T lookupValue(Map<Emoji, T> map, Emoji emoji) {
        String id = emoji instanceof CustomEmoji ? ((CustomEmoji)emoji).getId() : emoji.getFormatted();
        return map.entrySet().stream().filter(e -> {
            Emoji emj = (Emoji)e.getKey();
            if (emj instanceof CustomEmoji) {
                return ((CustomEmoji)emj).getId().equals(id);
            }
            return emj.getFormatted().equals(id);
        }).map(Map.Entry::getValue).findFirst().orElse(null);
    }

    public static void clearReactions(Message msg) {
        if (msg.getReactions().isEmpty()) {
            return;
        }
        try {
            if (msg.getChannel().getType().isGuild()) {
                msg.clearReactions().submit();
            } else {
                for (MessageReaction r : msg.getReactions()) {
                    r.removeReaction().submit();
                }
            }
        }
        catch (IllegalStateException | InsufficientPermissionException e) {
            for (MessageReaction r : msg.getReactions()) {
                r.removeReaction().submit();
            }
        }
    }

    public static void clearButtons(Message msg) {
        if (msg.getButtons().isEmpty()) {
            return;
        }
        try {
            Pages.subGet(msg.editMessageComponents(new LayoutComponent[0]));
        }
        catch (IllegalStateException | InsufficientPermissionException e) {
            paginator.log(PUtilsConfig.LogLevel.LEVEL_3, "Not enough permissions to clear message reactions:", e);
        }
    }

    public static void finalizeEvent(Message msg, Consumer<Void> callback) {
        if (!msg.isEphemeral()) {
            msg = Pages.reloadMessage(msg);
            Pages.clearButtons(msg);
            Pages.clearReactions(msg);
        }
        callback.accept(null);
    }

    public static void finalizeEvent(InteractionHook hook, Consumer<Void> callback) {
        hook.deleteOriginal().queue();
        callback.accept(null);
    }

    public static void modifyButtons(Message msg, @Nullable Page p, Map<String, Function<Button, Button>> changes) {
        MessageEditAction act = msg.editMessageComponents(new LayoutComponent[0]);
        if (p != null) {
            if (p.getContent() instanceof String) {
                act = msg.editMessage((CharSequence)((String)p.getContent()));
            } else if (p.getContent() instanceof MessageEmbed) {
                act = msg.editMessageEmbeds(new MessageEmbed[]{(MessageEmbed)p.getContent()});
            } else if (p.getContent() instanceof EmbedCluster) {
                act = msg.editMessageEmbeds(((EmbedCluster)p.getContent()).getEmbeds());
            }
        }
        List rows = msg.getComponents();
        for (LayoutComponent lc : rows) {
            List row = lc.getComponents();
            for (int i = 0; i < row.size(); ++i) {
                ItemComponent c = (ItemComponent)row.get(i);
                if (!(c instanceof Button)) continue;
                Button b = (Button)c;
                if (changes.containsKey(b.getId())) {
                    row.set(i, (ItemComponent)changes.get(b.getId()).apply((Button)c));
                    continue;
                }
                if (!changes.containsKey("default")) continue;
                row.set(i, (ItemComponent)changes.get("default").apply((Button)c));
            }
        }
        ((MessageEditAction)act.setComponents((Collection)rows)).submit();
    }

    public static void addReactions(Message msg, boolean withSkip, boolean withGoto) {
        Pages.clearButtons(msg);
        ArrayList<RestAction> acts = new ArrayList<RestAction>();
        if (withGoto) {
            acts.add(msg.addReaction(paginator.getEmoji(Emote.GOTO_FIRST)));
        }
        if (withSkip) {
            acts.add(msg.addReaction(paginator.getEmoji(Emote.SKIP_BACKWARD)));
        }
        acts.add(msg.addReaction(paginator.getEmoji(Emote.PREVIOUS)));
        acts.add(msg.addReaction(paginator.getEmoji(Emote.CANCEL)));
        acts.add(msg.addReaction(paginator.getEmoji(Emote.NEXT)));
        if (withSkip) {
            acts.add(msg.addReaction(paginator.getEmoji(Emote.SKIP_FORWARD)));
        }
        if (withGoto) {
            acts.add(msg.addReaction(paginator.getEmoji(Emote.GOTO_LAST)));
        }
        RestAction.allOf(acts).submit();
    }
}

