/*
 * Decompiled with CFR 0.152.
 */
package com.github.ygimenez.model;

import com.github.ygimenez.method.Pages;
import java.util.List;
import java.util.Map;
import net.dv8tion.jda.api.entities.Member;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.User;
import net.dv8tion.jda.api.entities.UserSnowflake;
import net.dv8tion.jda.api.entities.channel.middleman.MessageChannel;
import net.dv8tion.jda.api.interactions.InteractionHook;
import net.dv8tion.jda.api.interactions.components.buttons.Button;
import org.jetbrains.annotations.Nullable;

public class ButtonWrapper {
    private final User user;
    private final InteractionHook hook;
    private final Button button;
    private final Map<String, List<?>> dropdownValues;
    private Message message;

    public ButtonWrapper(User user, InteractionHook hook, Button button, Map<String, List<?>> dropdownValues, Message message) {
        this.user = user;
        this.hook = hook;
        this.button = button;
        this.dropdownValues = dropdownValues;
        this.message = message;
    }

    public User getUser() {
        return this.user;
    }

    public Member getMember() throws IllegalStateException {
        return (Member)Pages.subGet(this.message.getGuild().retrieveMember((UserSnowflake)this.user));
    }

    @Nullable
    public InteractionHook getHook() {
        return this.hook;
    }

    @Nullable
    public Button getButton() {
        return this.button;
    }

    public Map<String, List<?>> getDropdownValues() {
        return this.dropdownValues;
    }

    public Message getMessage() {
        return this.message;
    }

    public Message reloadMessage() {
        this.message = Pages.reloadMessage(this.message);
        return this.message;
    }

    public MessageChannel getChannel() {
        return this.message.getChannel();
    }
}

