/*
 * Decompiled with CFR 0.152.
 */
package com.github.ygimenez.model;

import com.github.ygimenez.method.Pages;
import com.github.ygimenez.model.EmbedCluster;
import com.github.ygimenez.model.Page;
import com.github.ygimenez.type.Emote;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import net.dv8tion.jda.api.entities.MessageEmbed;
import net.dv8tion.jda.api.entities.emoji.Emoji;
import net.dv8tion.jda.api.interactions.components.buttons.Button;
import net.dv8tion.jda.api.interactions.components.buttons.ButtonStyle;
import org.jetbrains.annotations.NotNull;

public class InteractPage
extends Page {
    private final Map<ButtonStyle, ButtonStyle> styles = new EnumMap<ButtonStyle, ButtonStyle>(ButtonStyle.class);
    private final Map<Emote, String> caption = new EnumMap<Emote, String>(Emote.class);

    protected InteractPage(@NotNull Object content) {
        super(content);
    }

    public static InteractPage of(@NotNull String content) {
        return new InteractPage(content);
    }

    public static InteractPage of(@NotNull MessageEmbed content) {
        return new InteractPage(content);
    }

    public static InteractPage of(@NotNull EmbedCluster content) {
        return new InteractPage(content);
    }

    public Map<ButtonStyle, ButtonStyle> getStyles() {
        return this.styles;
    }

    public void overrideStyle(ButtonStyle original, ButtonStyle override) {
        this.styles.put(original, override);
    }

    public Map<Emote, String> getCaptions() {
        return this.caption;
    }

    public Button makeButton(@NotNull Emote emt) {
        ButtonStyle style = this.styles.getOrDefault(emt.getStyle(), ButtonStyle.SECONDARY);
        if (emt == Emote.NONE) {
            return Button.secondary((String)(emt.name() + "." + Objects.hash(Math.random())), (String)"\u200b").asDisabled();
        }
        return Button.of((ButtonStyle)style, (String)emt.name(), (String)this.caption.get((Object)emt), (Emoji)Pages.getPaginator().getEmoji(emt));
    }

    public Button makeButton(@NotNull Emoji emj) {
        return Button.secondary((String)Emote.getId(emj), (Emoji)emj);
    }

    public Button makeButton(@NotNull Emoji emj, String caption) {
        return Button.of((ButtonStyle)ButtonStyle.SECONDARY, (String)Emote.getId(emj), (String)caption, (Emoji)emj);
    }
}

