/*
 * Decompiled with CFR 0.152.
 */
package com.github.ygimenez.model.helper;

import com.github.ygimenez.method.Pages;
import com.github.ygimenez.model.InteractPage;
import com.github.ygimenez.model.Page;
import com.github.ygimenez.model.helper.BaseHelper;
import com.github.ygimenez.type.Emote;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.dv8tion.jda.api.entities.Message;
import net.dv8tion.jda.api.entities.MessageEmbed;
import net.dv8tion.jda.api.entities.emoji.Emoji;
import net.dv8tion.jda.api.interactions.components.ActionRow;
import net.dv8tion.jda.api.interactions.components.LayoutComponent;
import net.dv8tion.jda.api.interactions.components.buttons.Button;
import net.dv8tion.jda.api.utils.messages.MessageRequest;

public class CategorizeHelper
extends BaseHelper<CategorizeHelper, Map<Emoji, Page>> {
    public CategorizeHelper(boolean useButtons) {
        super(CategorizeHelper.class, new LinkedHashMap(), useButtons);
    }

    public CategorizeHelper(Map<Emoji, Page> categories, boolean useButtons) {
        super(CategorizeHelper.class, categories, useButtons);
    }

    public CategorizeHelper addCategory(Emoji emoji, Page page) {
        ((Map)this.getContent()).put(emoji, page);
        return this;
    }

    @Override
    public <Out extends MessageRequest<Out>> List<LayoutComponent> getComponents(Out action) {
        if (!this.isUsingButtons()) {
            return List.of();
        }
        ArrayList<LayoutComponent> rows = new ArrayList<LayoutComponent>();
        ArrayList<Button> row = new ArrayList<Button>();
        for (Map.Entry e : ((Map)this.getContent()).entrySet()) {
            InteractPage p;
            if (row.size() == 5) {
                rows.add((LayoutComponent)ActionRow.of(row));
                row = new ArrayList();
            }
            if ((p = (InteractPage)e.getValue()) == null) continue;
            Button b = p.makeButton((Emoji)e.getKey());
            if (p.getContent() instanceof MessageEmbed) {
                for (MessageEmbed embed : action.getEmbeds()) {
                    if (!embed.equals(p.getContent())) continue;
                    b = b.asDisabled();
                    break;
                }
            } else if (action.getContent().equals(p.getContent())) {
                b = b.asDisabled();
            }
            row.add(b);
        }
        if (this.isCancellable()) {
            Button button = Button.danger((String)Emote.CANCEL.name(), (Emoji)Pages.getPaginator().getEmoji(Emote.CANCEL));
            if (rows.size() == 5 && row.size() == 5) {
                row.set(4, button);
            } else if (row.size() == 5) {
                rows.add((LayoutComponent)ActionRow.of(row));
                row = new ArrayList();
                row.add(button);
            } else {
                row.add(button);
            }
        }
        rows.add((LayoutComponent)ActionRow.of(row));
        return rows;
    }

    @Override
    public boolean shouldUpdate(Message msg) {
        if (!this.isUsingButtons()) {
            return false;
        }
        Predicate<Set> checks = e -> !this.isCancellable() || e.contains(Pages.getPaginator().getEmoji(Emote.CANCEL));
        Set emojis = msg.getButtons().stream().map(Button::getEmoji).collect(Collectors.toSet());
        return !(checks = checks.and(e -> e.containsAll(((Map)this.getContent()).keySet()))).test(emojis);
    }
}

