/*
 * Decompiled with CFR 0.152.
 */
package com.github.yingzhuo.carnival.mvc.autoconfig;

import javax.servlet.Filter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;
import org.springframework.web.filter.CorsFilter;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@ConditionalOnWebApplication
@EnableConfigurationProperties(value={Props.class})
@ConditionalOnProperty(prefix="carnival.mvc.cors-for-all", name={"enabled"}, havingValue="true")
public class MvcCorsForAllAutoConfig
implements WebMvcConfigurer {
    @Bean
    public FilterRegistrationBean<CorsFilter> corsFilterRegistrationBean() {
        FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean();
        filterRegistrationBean.setFilter((Filter)this.corsFilter());
        filterRegistrationBean.addUrlPatterns(new String[]{"/", "/*"});
        filterRegistrationBean.setName(CorsFilter.class.getSimpleName());
        return filterRegistrationBean;
    }

    private CorsFilter corsFilter() {
        CorsConfiguration corsConfiguration = new CorsConfiguration();
        corsConfiguration.addAllowedOrigin("*");
        corsConfiguration.addAllowedHeader("*");
        corsConfiguration.addAllowedMethod("*");
        UrlBasedCorsConfigurationSource urlBasedCorsConfigurationSource = new UrlBasedCorsConfigurationSource();
        urlBasedCorsConfigurationSource.registerCorsConfiguration("/**", corsConfiguration);
        return new CorsFilter((CorsConfigurationSource)urlBasedCorsConfigurationSource);
    }

    @ConfigurationProperties(prefix="carnival.mvc.cors-for-all")
    static class Props {
        private boolean enabled = false;

        Props() {
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean bl) {
            this.enabled = bl;
        }
    }
}

