/*
 * Decompiled with CFR 0.152.
 */
package com.github.yingzhuo.carnival.mvc.autoconfig;

import com.github.yingzhuo.carnival.mvc.support.IpAddressHandlerMethodArgumentResolver;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.servlet.config.annotation.PathMatchConfigurer;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.servlet.view.BeanNameViewResolver;
import org.springframework.web.util.UrlPathHelper;

@ConditionalOnWebApplication
@EnableConfigurationProperties(value={Props.class})
@ConditionalOnProperty(prefix="carnival.mvc.enhancement", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class MvcEnhancementAutoConfig
implements WebMvcConfigurer {
    @Autowired(required=false)
    public void config(BeanNameViewResolver beanNameViewResolver) {
        if (beanNameViewResolver != null) {
            beanNameViewResolver.setOrder(Integer.MIN_VALUE);
        }
    }

    public void configurePathMatch(PathMatchConfigurer pathMatchConfigurer) {
        UrlPathHelper urlPathHelper = Optional.ofNullable(pathMatchConfigurer.getUrlPathHelper()).orElseGet(UrlPathHelper::new);
        urlPathHelper.setDefaultEncoding("UTF-8");
        urlPathHelper.setRemoveSemicolonContent(false);
        pathMatchConfigurer.setUrlPathHelper(urlPathHelper);
    }

    public void addArgumentResolvers(List<HandlerMethodArgumentResolver> list) {
        list.add(new IpAddressHandlerMethodArgumentResolver());
    }

    @ConfigurationProperties(value="carnival.mvc.enhancement")
    static class Props {
        private boolean enabled = true;

        Props() {
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean bl) {
            this.enabled = bl;
        }
    }
}

