/*
 * Decompiled with CFR 0.152.
 */
package com.github.yingzhuo.carnival.mvc.autoconfig;

import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.http.HttpStatus;
import org.springframework.web.servlet.config.annotation.ViewControllerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@ConditionalOnWebApplication
@ConditionalOnProperty(prefix="carnival.mvc.kubernetes", name={"enabled"}, havingValue="true")
@EnableConfigurationProperties(value={Props.class})
public class MvcKubernetesAutoConfig
implements WebMvcConfigurer {
    @Autowired
    private Props props;

    public void addViewControllers(ViewControllerRegistry viewControllerRegistry) {
        if (StringUtils.equals((CharSequence)this.props.getLivenessProbePath(), (CharSequence)this.props.getReadinessProbePath())) {
            viewControllerRegistry.addStatusController(this.props.getLivenessProbePath(), HttpStatus.OK);
        } else {
            viewControllerRegistry.addStatusController(this.props.getLivenessProbePath(), HttpStatus.OK);
            viewControllerRegistry.addStatusController(this.props.getReadinessProbePath(), HttpStatus.OK);
        }
    }

    @ConfigurationProperties(prefix="carnival.mvc.kubernetes")
    static class Props {
        private boolean enabled = false;
        private String livenessProbePath = "/liveness-probe";
        private String readinessProbePath = "/readiness-probe";

        Props() {
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public String getLivenessProbePath() {
            return this.livenessProbePath;
        }

        public String getReadinessProbePath() {
            return this.readinessProbePath;
        }

        public void setEnabled(boolean bl) {
            this.enabled = bl;
        }

        public void setLivenessProbePath(String string) {
            this.livenessProbePath = string;
        }

        public void setReadinessProbePath(String string) {
            this.readinessProbePath = string;
        }
    }
}

