/*
 * Decompiled with CFR 0.152.
 */
package com.github.yingzhuo.carnival.mvc.autoconfig;

import com.github.yingzhuo.carnival.mvc.support.WebrootSettingInterceptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@ConditionalOnWebApplication
@ConditionalOnProperty(prefix="carnival.mvc.webroot", name={"enabled"}, havingValue="true")
@EnableConfigurationProperties(value={Props.class})
public class MvcWebrootAutoConfig
implements WebMvcConfigurer {
    @Autowired
    private Props props;

    public void addInterceptors(InterceptorRegistry interceptorRegistry) {
        interceptorRegistry.addInterceptor((HandlerInterceptor)new WebrootSettingInterceptor(this.props.getAttributeName())).addPathPatterns(new String[]{"/", "/**"});
    }

    @ConfigurationProperties(value="carnival.mvc.webroot")
    static class Props {
        private boolean enabled = false;
        private String attributeName = "WEBROOT";

        Props() {
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public String getAttributeName() {
            return this.attributeName;
        }

        public void setEnabled(boolean bl) {
            this.enabled = bl;
        }

        public void setAttributeName(String string) {
            this.attributeName = string;
        }
    }
}

