/*
 * Decompiled with CFR 0.152.
 */
package com.github.yingzhuo.carnival.mvc.support;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.URLDecoder;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;

public class DebugMvcInterceptor
implements HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(DebugMvcInterceptor.class);

    public boolean preHandle(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object object) {
        if (!log.isDebugEnabled()) {
            return true;
        }
        if (!(object instanceof HandlerMethod)) {
            return true;
        }
        try {
            this.doLog(httpServletRequest, (HandlerMethod)object);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return true;
    }

    private void doLog(HttpServletRequest httpServletRequest, HandlerMethod handlerMethod) {
        Object object;
        Object object2;
        Object object3;
        log.debug(StringUtils.repeat((char)'-', (int)120));
        log.debug("[Path]: ");
        log.debug("\t\t\t{}", (Object)this.decode(httpServletRequest.getRequestURI()));
        log.debug("[Method]: ");
        log.debug("\t\t\t{}", (Object)httpServletRequest.getMethod());
        log.debug("[Headers]: ");
        Enumeration enumeration = httpServletRequest.getHeaderNames();
        while (enumeration.hasMoreElements()) {
            object3 = (String)enumeration.nextElement();
            object2 = httpServletRequest.getHeader((String)object3);
            log.debug("\t\t\t{} = {}", object3, ((String)object3).equalsIgnoreCase("cookie") ? StringUtils.abbreviate((String)object2, (int)60) : object2);
        }
        log.debug("[Params]: ");
        object3 = httpServletRequest.getParameterNames();
        while (object3.hasMoreElements()) {
            object2 = (String)object3.nextElement();
            object = httpServletRequest.getParameter((String)object2);
            log.debug("\t\t\t{} = {}", object2, object);
        }
        if (handlerMethod != null) {
            object2 = handlerMethod.getMethod();
            object = handlerMethod.getBeanType();
            boolean bl = ((Method)object2).getAnnotation(Deprecated.class) != null;
            boolean bl2 = ((Class)object).getAnnotation(Deprecated.class) != null;
            log.debug("[Controller]: ");
            log.debug("\t\t\ttype = {}{}", (Object)((Class)object).getName(), (Object)(bl ? "(Deprecated)" : ""));
            log.debug("\t\t\tmethod-name = {}{}", (Object)((Method)object2).getName(), (Object)(bl2 ? "(Deprecated)" : ""));
        }
        log.debug(StringUtils.repeat((char)'-', (int)120));
    }

    private String decode(String string) {
        try {
            return URLDecoder.decode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new AssertionError();
        }
    }
}

