/*
 * Decompiled with CFR 0.152.
 */
package com.github.yingzhuo.carnival.mvc.support;

import com.github.yingzhuo.carnival.common.util.HexUtils;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.springframework.core.io.Resource;

public final class DownloadingFile {
    private byte[] content;
    private String filename;
    private Charset filenameCharset = StandardCharsets.ISO_8859_1;

    DownloadingFile() {
    }

    public static Builder builder() {
        return new Builder();
    }

    public byte[] getContent() {
        return this.content;
    }

    public String getFilename() {
        return this.filename;
    }

    public Charset getFilenameCharset() {
        return this.filenameCharset;
    }

    public void setContent(byte[] byArray) {
        this.content = byArray;
    }

    public void setFilename(String string) {
        this.filename = string;
    }

    public void setFilenameCharset(Charset charset) {
        this.filenameCharset = charset;
    }

    public static class Builder {
        private byte[] content = new byte[0];
        private String filename = "file";
        private Charset filenameCharset = StandardCharsets.ISO_8859_1;

        Builder() {
        }

        public Builder content(Resource resource) {
            InputStream inputStream = resource.getInputStream();
            this.content = IOUtils.toByteArray((InputStream)inputStream);
            IOUtils.closeQuietly((InputStream)inputStream);
            return this;
        }

        public Builder content(byte[] byArray) {
            this.content = byArray;
            return this;
        }

        public Builder content(String string) {
            this.content = HexUtils.decode((CharSequence)string);
            return this;
        }

        public Builder filename(String string) {
            this.filename = string;
            return this;
        }

        public Builder filenameCharset(Charset charset) {
            this.filenameCharset = charset;
            return this;
        }

        public DownloadingFile build() {
            DownloadingFile downloadingFile = new DownloadingFile();
            downloadingFile.setContent(this.content);
            downloadingFile.setFilename(this.filename);
            downloadingFile.setFilenameCharset(this.filenameCharset);
            return downloadingFile;
        }
    }
}

