/*
 * Decompiled with CFR 0.152.
 */
package com.github.yingzhuo.carnival.mvc.support;

import com.github.yingzhuo.carnival.mvc.support.DownloadingFile;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.springframework.core.MethodParameter;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodReturnValueHandler;
import org.springframework.web.method.support.ModelAndViewContainer;
import org.springframework.web.servlet.View;

public class DownloadingHandlerMethodReturnValueHandler
implements HandlerMethodReturnValueHandler {
    public boolean supportsReturnType(MethodParameter methodParameter) {
        return methodParameter.getParameterType() == DownloadingFile.class;
    }

    public void handleReturnValue(Object object, MethodParameter methodParameter, ModelAndViewContainer modelAndViewContainer, NativeWebRequest nativeWebRequest) {
        modelAndViewContainer.setView((Object)new DownloadingFileView((DownloadingFile)object));
    }

    private static class DownloadingFileView
    implements View {
        private final DownloadingFile df;

        public DownloadingFileView(DownloadingFile downloadingFile) {
            this.df = Objects.requireNonNull(downloadingFile);
        }

        public void render(Map<String, ?> map, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
            String string = new String(this.df.getFilename().getBytes(StandardCharsets.UTF_8), this.df.getFilenameCharset());
            ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
            httpServletResponse.setCharacterEncoding("UTF-8");
            httpServletResponse.setContentType("multipart/form-data");
            httpServletResponse.setHeader("Content-Disposition", "attachment;fileName=" + string);
            httpServletResponse.setContentLength(this.df.getContent().length);
            IOUtils.write((byte[])this.df.getContent(), (OutputStream)servletOutputStream);
            IOUtils.closeQuietly((OutputStream)servletOutputStream);
        }
    }
}

