/*
 * Decompiled with CFR 0.152.
 */
package com.github.yingzhuo.carnival.mvc.support;

import java.awt.image.BufferedImage;
import java.io.Serializable;

public final class Image
implements Serializable {
    private Format format;
    private BufferedImage image;

    public static ImageBuilder builder() {
        return new ImageBuilder();
    }

    public Format getFormat() {
        return this.format;
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public void setFormat(Format format) {
        this.format = format;
    }

    public void setImage(BufferedImage bufferedImage) {
        this.image = bufferedImage;
    }

    public Image() {
    }

    public Image(Format format, BufferedImage bufferedImage) {
        this.format = format;
        this.image = bufferedImage;
    }

    public static class ImageBuilder {
        private Format format;
        private BufferedImage image;

        ImageBuilder() {
        }

        public ImageBuilder format(Format format) {
            this.format = format;
            return this;
        }

        public ImageBuilder image(BufferedImage bufferedImage) {
            this.image = bufferedImage;
            return this;
        }

        public Image build() {
            return new Image(this.format, this.image);
        }

        public String toString() {
            return "Image.ImageBuilder(format=" + (Object)((Object)this.format) + ", image=" + this.image + ")";
        }
    }

    public static enum Format {
        PNG("png"),
        JPG("jpg"),
        JPEG("jpeg"),
        GIF("gif"),
        BMP("bmp"),
        WBMP("wbmp");

        private final String name;

        private Format(String string2) {
            this.name = string2;
        }

        public String getName() {
            return this.name;
        }
    }
}

