/*
 * Decompiled with CFR 0.152.
 */
package com.github.yingzhuo.carnival.mvc.support;

import com.github.yingzhuo.carnival.mvc.support.Image;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.core.MethodParameter;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodReturnValueHandler;
import org.springframework.web.method.support.ModelAndViewContainer;
import org.springframework.web.servlet.View;

public class ImageHandlerMethodReturnValueHandler
implements HandlerMethodReturnValueHandler {
    public boolean supportsReturnType(MethodParameter methodParameter) {
        return methodParameter.getParameterType() == Image.class;
    }

    public void handleReturnValue(Object object, MethodParameter methodParameter, ModelAndViewContainer modelAndViewContainer, NativeWebRequest nativeWebRequest) {
        modelAndViewContainer.setView((Object)new ImageView((Image)object));
    }

    private static class ImageView
    implements View {
        private final Image image;

        private ImageView(Image image) {
            this.image = image;
        }

        public void render(Map<String, ?> map, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
            httpServletResponse.setHeader("cache", "no-cache");
            ServletOutputStream servletOutputStream = httpServletResponse.getOutputStream();
            ImageIO.write((RenderedImage)this.image.getImage(), this.image.getFormat().getName(), (OutputStream)servletOutputStream);
            servletOutputStream.flush();
            servletOutputStream.close();
        }

        public String getContentType() {
            return "image/" + this.image.getFormat().getName();
        }
    }
}

