/*
 * Decompiled with CFR 0.152.
 */
package com.github.yingzhuo.carnival.mvc.autoconfig;

import com.github.yingzhuo.carnival.mvc.support.DownloadingHandlerMethodReturnValueHandler;
import com.github.yingzhuo.carnival.mvc.support.ImageHandlerMethodReturnValueHandler;
import com.github.yingzhuo.carnival.mvc.support.IpAddressHandlerMethodArgumentResolver;
import com.github.yingzhuo.carnival.mvc.support.UserAgentHandlerMethodArgumentResolver;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.HandlerMethodReturnValueHandler;
import org.springframework.web.servlet.config.annotation.PathMatchConfigurer;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.servlet.view.BeanNameViewResolver;
import org.springframework.web.util.UrlPathHelper;

@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
public class MvcCommonAutoConfig
implements WebMvcConfigurer {
    @Autowired(required=false)
    public void config(BeanNameViewResolver beanNameViewResolver) {
        if (beanNameViewResolver != null) {
            beanNameViewResolver.setOrder(Integer.MIN_VALUE);
        }
    }

    public void configurePathMatch(PathMatchConfigurer pathMatchConfigurer) {
        UrlPathHelper urlPathHelper = Optional.ofNullable(pathMatchConfigurer.getUrlPathHelper()).orElseGet(UrlPathHelper::new);
        urlPathHelper.setDefaultEncoding("UTF-8");
        urlPathHelper.setRemoveSemicolonContent(false);
        pathMatchConfigurer.setUrlPathHelper(urlPathHelper);
    }

    public void addArgumentResolvers(List<HandlerMethodArgumentResolver> list) {
        list.add(new IpAddressHandlerMethodArgumentResolver());
        list.add(new UserAgentHandlerMethodArgumentResolver());
    }

    public void addReturnValueHandlers(List<HandlerMethodReturnValueHandler> list) {
        list.add(new DownloadingHandlerMethodReturnValueHandler());
        list.add(new ImageHandlerMethodReturnValueHandler());
    }
}

