/*
 * Decompiled with CFR 0.152.
 */
package com.github.yingzhuo.carnival.mvc.autoconfig;

import com.github.yingzhuo.carnival.mvc.autoconfig.filter.HttpBasicSecurityFilter;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.Filter;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;

@ConditionalOnWebApplication
@ConditionalOnProperty(prefix="carnival.mvc.http-basic", name={"enabled"}, havingValue="true")
@EnableConfigurationProperties(value={Props.class})
public class MvcHttpBasicSecurityAutoConfig {
    @Autowired(required=false)
    private HttpBasicSecurityFilter.AccessDeniedHandler accessDeniedHandler;

    @Bean
    @Autowired(required=false)
    public FilterRegistrationBean<HttpBasicSecurityFilter> httpBasicSecurityFilter(Props props) {
        FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean();
        filterRegistrationBean.setFilter((Filter)new HttpBasicSecurityFilter(this.accessDeniedHandler, props.getUsernameAndPassword()));
        filterRegistrationBean.setName(HttpBasicSecurityFilter.class.getName());
        filterRegistrationBean.setOrder(props.getOrder());
        filterRegistrationBean.addUrlPatterns(props.getUrlPattern());
        return filterRegistrationBean;
    }

    @ConfigurationProperties(value="carnival.mvc.http-basic")
    static class Props
    implements InitializingBean {
        private boolean enabled = false;
        private String[] urlPattern;
        private Map<String, String> usernameAndPassword;
        private int order = Integer.MIN_VALUE;

        Props() {
        }

        public void afterPropertiesSet() {
            if (this.usernameAndPassword == null) {
                this.usernameAndPassword = new HashMap<String, String>();
            }
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public String[] getUrlPattern() {
            return this.urlPattern;
        }

        public Map<String, String> getUsernameAndPassword() {
            return this.usernameAndPassword;
        }

        public int getOrder() {
            return this.order;
        }

        public void setEnabled(boolean bl) {
            this.enabled = bl;
        }

        public void setUrlPattern(String[] stringArray) {
            this.urlPattern = stringArray;
        }

        public void setUsernameAndPassword(Map<String, String> map) {
            this.usernameAndPassword = map;
        }

        public void setOrder(int n) {
            this.order = n;
        }
    }
}

