/*
 * Decompiled with CFR 0.152.
 */
package com.github.yingzhuo.carnival.mvc.autoconfig;

import com.github.yingzhuo.carnival.mvc.support.XssProtectingRequest;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.web.filter.OncePerRequestFilter;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@ConditionalOnWebApplication
@ConditionalOnProperty(prefix="carnival.mvc.xss-protecting", name={"enabled"}, havingValue="true")
@EnableConfigurationProperties(value={Props.class})
public class MvcXssProtectingAutoConfig
implements WebMvcConfigurer {
    @Bean
    public FilterRegistrationBean<XssProtectingFilter> xssProtectingFilter() {
        FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean();
        filterRegistrationBean.setFilter((Filter)new XssProtectingFilter());
        filterRegistrationBean.setName(XssProtectingFilter.class.getSimpleName());
        filterRegistrationBean.addUrlPatterns(new String[]{"/", "/**"});
        filterRegistrationBean.setOrder(0);
        return filterRegistrationBean;
    }

    public static class XssProtectingFilter
    extends OncePerRequestFilter {
        protected void doFilterInternal(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws ServletException, IOException {
            filterChain.doFilter((ServletRequest)new XssProtectingRequest(httpServletRequest), (ServletResponse)httpServletResponse);
        }
    }

    @ConfigurationProperties(value="carnival.mvc.xss-protecting")
    static class Props {
        private boolean enabled = false;

        Props() {
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean bl) {
            this.enabled = bl;
        }
    }
}

