/*
 * Decompiled with CFR 0.152.
 */
package com.github.yingzhuo.carnival.mvc.autoconfig.filter;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.http.HttpStatus;
import org.springframework.web.filter.OncePerRequestFilter;

public class HttpBasicSecurityFilter
extends OncePerRequestFilter {
    private static final String AUTHORIZATION = "Authorization";
    private static final String BASIC = "Basic ";
    private final AccessDeniedHandler accessDeniedHandler;
    private final Map<String, String> usernameAndPasswordMap = new HashMap<String, String>();

    public HttpBasicSecurityFilter() {
        this(null, null);
    }

    public HttpBasicSecurityFilter(AccessDeniedHandler accessDeniedHandler, Map<String, String> map) {
        AccessDeniedHandler accessDeniedHandler2 = this.accessDeniedHandler = accessDeniedHandler != null ? accessDeniedHandler : httpServletResponse -> {
            httpServletResponse.setStatus(HttpStatus.FORBIDDEN.value());
            httpServletResponse.getWriter().write("Access Denied");
            httpServletResponse.getWriter().flush();
        };
        if (map != null) {
            this.usernameAndPasswordMap.putAll(map);
        }
    }

    protected void doFilterInternal(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws ServletException, IOException {
        String string = httpServletRequest.getHeader(AUTHORIZATION);
        if (string == null) {
            this.accessDeniedHandler.handle(httpServletResponse);
            return;
        }
        if (!string.startsWith(BASIC)) {
            this.accessDeniedHandler.handle(httpServletResponse);
            return;
        }
        String string2 = string.substring(BASIC.length());
        string2 = new String(Base64.getUrlDecoder().decode(string2.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
        String[] stringArray = string2.split(":", 2);
        if (stringArray.length != 2) {
            this.accessDeniedHandler.handle(httpServletResponse);
            return;
        }
        String string3 = stringArray[1];
        String string4 = stringArray[0];
        if (!Objects.equals(string3, this.usernameAndPasswordMap.get(string4))) {
            this.accessDeniedHandler.handle(httpServletResponse);
            return;
        }
        filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
    }

    @FunctionalInterface
    public static interface AccessDeniedHandler {
        public void handle(HttpServletResponse var1) throws ServletException, IOException;
    }
}

