/*
 * Decompiled with CFR 0.152.
 */
package com.github.yingzhuo.carnival.mvc.autoconfig;

import com.github.yingzhuo.carnival.mvc.support.WebrootSettingInterceptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Lazy;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Lazy(value=false)
@ConditionalOnWebApplication
@ConditionalOnProperty(prefix="carnival.mvc.webroot", name={"enabled"}, havingValue="true", matchIfMissing=false)
@EnableConfigurationProperties(value={Props.class})
public class MvcWebrootAutoConfig
implements WebMvcConfigurer {
    @Autowired
    private Props props;

    public void addInterceptors(InterceptorRegistry interceptorRegistry) {
        interceptorRegistry.addInterceptor((HandlerInterceptor)new WebrootSettingInterceptor(this.props.getRequestAttributeName())).addPathPatterns(new String[]{"/", "/**"});
    }

    @ConfigurationProperties(value="carnival.mvc.webroot")
    static class Props {
        private boolean enabled = false;
        private String requestAttributeName = "WEBROOT";

        Props() {
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public String getRequestAttributeName() {
            return this.requestAttributeName;
        }

        public void setEnabled(boolean bl) {
            this.enabled = bl;
        }

        public void setRequestAttributeName(String string) {
            this.requestAttributeName = string;
        }
    }
}

