/*
 * Decompiled with CFR 0.152.
 */
package com.github.yingzhuo.carnival.mvc.autoconfig;

import com.github.yingzhuo.carnival.mvc.client.ClientAppVersionResolver;
import com.github.yingzhuo.carnival.mvc.client.ClientInfoResolver;
import com.github.yingzhuo.carnival.mvc.client.ClientInfoResolvingFilter;
import com.github.yingzhuo.carnival.mvc.client.ClientOSTypeResolver;
import com.github.yingzhuo.carnival.mvc.client.ClientOSVersionResolver;
import com.github.yingzhuo.carnival.mvc.client.ClientUsingBackendVersionResolver;
import com.github.yingzhuo.carnival.mvc.props.AbstractWebFilterProps;
import javax.servlet.Filter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Lazy;

@Lazy(value=false)
@ConditionalOnWebApplication
@EnableConfigurationProperties(value={Props.class})
@ConditionalOnProperty(prefix="carnival.web-filter.client-info", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class MvcClientInfoAutoConfig {
    @Autowired(required=false)
    private ClientOSTypeResolver clientOSTypeResolver;
    @Autowired(required=false)
    private ClientOSVersionResolver clientOSVersionResolver;
    @Autowired(required=false)
    private ClientAppVersionResolver clientAppVersionResolver;
    @Autowired(required=false)
    private ClientUsingBackendVersionResolver clientUsingBackendVersionResolver;

    @Bean
    public FilterRegistrationBean<ClientInfoResolvingFilter> clientOSTypeResolvingFilterFilter(Props props) {
        FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean();
        filterRegistrationBean.setFilter((Filter)new ClientInfoResolvingFilter(this.clientOSTypeResolver != null ? this.clientOSTypeResolver : ClientInfoResolver.DEFAULT, this.clientOSVersionResolver != null ? this.clientOSVersionResolver : ClientInfoResolver.DEFAULT, this.clientAppVersionResolver != null ? this.clientAppVersionResolver : ClientInfoResolver.DEFAULT, this.clientUsingBackendVersionResolver != null ? this.clientUsingBackendVersionResolver : ClientInfoResolver.DEFAULT));
        filterRegistrationBean.setOrder(props.getOrder());
        filterRegistrationBean.addUrlPatterns(props.getUrlPatterns());
        filterRegistrationBean.setName(props.getFilterName());
        return filterRegistrationBean;
    }

    @ConfigurationProperties(prefix="carnival.web-filter.client-info")
    static class Props
    extends AbstractWebFilterProps {
        private boolean enabled = true;

        Props() {
            super.setOrder(Integer.MAX_VALUE);
            super.setFilterName(ClientInfoResolvingFilter.class.getName());
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean bl) {
            this.enabled = bl;
        }
    }
}

