/*
 * Decompiled with CFR 0.152.
 */
package com.github.yingzhuo.carnival.mvc.autoconfig;

import com.github.yingzhuo.carnival.mvc.props.AbstractWebFilterProps;
import javax.servlet.Filter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Lazy;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;
import org.springframework.web.filter.CorsFilter;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Lazy(value=false)
@ConditionalOnWebApplication
@EnableConfigurationProperties(value={Props.class})
@ConditionalOnProperty(prefix="carnival.web-filter.cors", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class MvcCorsAutoConfig
implements WebMvcConfigurer {
    @Bean
    public FilterRegistrationBean<CorsFilter> corsFilterRegistrationBean(Props props) {
        FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean();
        filterRegistrationBean.setFilter((Filter)this.corsFilter());
        filterRegistrationBean.addUrlPatterns(props.getUrlPatterns());
        filterRegistrationBean.setName(props.getFilterName());
        filterRegistrationBean.setOrder(props.getOrder());
        return filterRegistrationBean;
    }

    private CorsFilter corsFilter() {
        CorsConfiguration corsConfiguration = new CorsConfiguration();
        corsConfiguration.addAllowedOrigin("*");
        corsConfiguration.addAllowedHeader("*");
        corsConfiguration.addAllowedMethod("*");
        UrlBasedCorsConfigurationSource urlBasedCorsConfigurationSource = new UrlBasedCorsConfigurationSource();
        urlBasedCorsConfigurationSource.registerCorsConfiguration("/**", corsConfiguration);
        return new CorsFilter((CorsConfigurationSource)urlBasedCorsConfigurationSource);
    }

    @ConfigurationProperties(prefix="carnival.web-filter.cors")
    static class Props
    extends AbstractWebFilterProps {
        private boolean enabled = true;

        Props() {
            super.setOrder(2147483547);
            super.setFilterName(CorsFilter.class.getName());
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean bl) {
            this.enabled = bl;
        }
    }
}

