/*
 * Decompiled with CFR 0.152.
 */
package com.github.yingzhuo.carnival.mvc.client;

import com.github.yingzhuo.carnival.mvc.client.ClientAppVersionResolver;
import com.github.yingzhuo.carnival.mvc.client.ClientOSType;
import com.github.yingzhuo.carnival.mvc.client.ClientOSTypeResolver;
import com.github.yingzhuo.carnival.mvc.client.ClientOSVersionResolver;
import com.github.yingzhuo.carnival.mvc.client.ClientUsingBackendVersionResolver;
import org.springframework.web.context.request.NativeWebRequest;

public interface ClientInfoResolver
extends ClientOSTypeResolver,
ClientOSVersionResolver,
ClientAppVersionResolver,
ClientUsingBackendVersionResolver {
    public static final ClientInfoResolver DEFAULT = new ClientInfoResolver(){};

    @Override
    default public ClientOSType resolveClientOSType(NativeWebRequest nativeWebRequest) {
        String string = nativeWebRequest.getHeader("X-Client-OS-Type");
        if (string == null) {
            return null;
        }
        if (string.equalsIgnoreCase("ANDROID")) {
            return ClientOSType.ANDROID;
        }
        if (string.equalsIgnoreCase("IOS")) {
            return ClientOSType.IOS;
        }
        return null;
    }

    @Override
    default public String resolveClientOSVersion(NativeWebRequest nativeWebRequest) {
        return nativeWebRequest.getHeader("X-Client-OS-Version");
    }

    @Override
    default public String resolveClientAppVersion(NativeWebRequest nativeWebRequest) {
        return nativeWebRequest.getHeader("X-Client-App-Version");
    }

    @Override
    default public String resolveClientUsingBackendVersion(NativeWebRequest nativeWebRequest) {
        return nativeWebRequest.getHeader("X-Client-Using-Backend-Version");
    }
}

