/*
 * Decompiled with CFR 0.152.
 */
package com.github.yingzhuo.carnival.mvc.client;

import com.github.yingzhuo.carnival.mvc.client.ClientAppVersionResolver;
import com.github.yingzhuo.carnival.mvc.client.ClientInfoContext;
import com.github.yingzhuo.carnival.mvc.client.ClientOSTypeResolver;
import com.github.yingzhuo.carnival.mvc.client.ClientOSVersionResolver;
import com.github.yingzhuo.carnival.mvc.client.ClientUsingBackendVersionResolver;
import java.io.IOException;
import java.util.Objects;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.filter.OncePerRequestFilter;

public class ClientInfoResolvingFilter
extends OncePerRequestFilter {
    private final ClientOSTypeResolver clientOSTypeResolver;
    private final ClientOSVersionResolver clientOSVersionResolver;
    private final ClientAppVersionResolver clientAppVersionResolver;
    private final ClientUsingBackendVersionResolver clientUsingBackendVersionResolver;

    public ClientInfoResolvingFilter(ClientOSTypeResolver clientOSTypeResolver, ClientOSVersionResolver clientOSVersionResolver, ClientAppVersionResolver clientAppVersionResolver, ClientUsingBackendVersionResolver clientUsingBackendVersionResolver) {
        this.clientOSTypeResolver = Objects.requireNonNull(clientOSTypeResolver);
        this.clientOSVersionResolver = Objects.requireNonNull(clientOSVersionResolver);
        this.clientAppVersionResolver = Objects.requireNonNull(clientAppVersionResolver);
        this.clientUsingBackendVersionResolver = Objects.requireNonNull(clientUsingBackendVersionResolver);
    }

    protected void doFilterInternal(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws ServletException, IOException {
        ServletWebRequest servletWebRequest = new ServletWebRequest(httpServletRequest);
        ClientInfoContext.setClientOsType(this.clientOSTypeResolver.resolveClientOSType((NativeWebRequest)servletWebRequest));
        ClientInfoContext.setClientOsVersion(this.clientOSVersionResolver.resolveClientOSVersion((NativeWebRequest)servletWebRequest));
        ClientInfoContext.setClientAppVersion(this.clientAppVersionResolver.resolveClientAppVersion((NativeWebRequest)servletWebRequest));
        ClientInfoContext.setClientUsingBackendVersion(this.clientUsingBackendVersionResolver.resolveClientUsingBackendVersion((NativeWebRequest)servletWebRequest));
        filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
        ClientInfoContext.clean();
    }
}

