/*
 * Decompiled with CFR 0.152.
 */
package com.github.yingzhuo.carnival.mvc.responsibility;

import com.github.yingzhuo.carnival.mvc.responsibility.Responsibility;
import com.github.yingzhuo.carnival.mvc.responsibility.ResponsibilityChain;
import com.github.yingzhuo.carnival.spring.PathMatcherUtils;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.context.request.ServletWebRequest;
import org.springframework.web.filter.OncePerRequestFilter;

public class ResponsibilityChainFilter
extends OncePerRequestFilter {
    private final ResponsibilityChain chain;

    public ResponsibilityChainFilter(ResponsibilityChain responsibilityChain) {
        this.chain = responsibilityChain;
    }

    protected void doFilterInternal(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws ServletException, IOException {
        if (this.chain != null && !this.chain.isEmpty()) {
            String string = httpServletRequest.getRequestURI();
            for (Responsibility responsibility : this.chain) {
                String[] stringArray = responsibility.excludePatterns();
                if (stringArray != null && stringArray.length > 0 && PathMatcherUtils.anyMatch((String)string, (String[])stringArray)) continue;
                responsibility.execute((NativeWebRequest)new ServletWebRequest(httpServletRequest, httpServletResponse));
            }
        }
        filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
    }
}

