/*
 * Decompiled with CFR 0.152.
 */
package com.github.yingzhuo.carnival.mvc.support;

import com.github.yingzhuo.carnival.common.mvc.AbstractHandlerInterceptorSupport;
import com.github.yingzhuo.carnival.mvc.NoDebug;
import com.github.yingzhuo.carnival.mvc.client.ClientInfoContext;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.web.method.HandlerMethod;

public class DebugMvcInterceptor
extends AbstractHandlerInterceptorSupport {
    private static final Logger log = LoggerFactory.getLogger(DebugMvcInterceptor.class);

    public boolean preHandle(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Object object) {
        if (!log.isDebugEnabled()) {
            return true;
        }
        if (this.hasMethodOrClassAnnotation(NoDebug.class, object)) {
            return true;
        }
        if (!(object instanceof HandlerMethod)) {
            return true;
        }
        try {
            this.doLog(httpServletRequest, (HandlerMethod)object);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return true;
    }

    private void doLog(HttpServletRequest httpServletRequest, HandlerMethod handlerMethod) {
        String string;
        Object object;
        Object object2;
        Object object3;
        log.debug(StringUtils.repeat((char)'-', (int)120));
        log.debug("[Path]:");
        log.debug("\t\t{}", (Object)this.decode(httpServletRequest.getRequestURI()));
        log.debug("[Method]:");
        log.debug("\t\t{}", (Object)httpServletRequest.getMethod());
        log.debug("[Headers]:");
        Enumeration enumeration = httpServletRequest.getHeaderNames();
        while (enumeration.hasMoreElements()) {
            object3 = (String)enumeration.nextElement();
            object2 = httpServletRequest.getHeader((String)object3);
            log.debug("\t\t{} = {}", object3, ((String)object3).equalsIgnoreCase("cookie") ? StringUtils.abbreviate((String)object2, (int)60) : object2);
        }
        object3 = this.getLocale();
        if (object3 != null) {
            log.debug("[Locale]:");
            log.debug("\t\t{}", (Object)this.getLocale());
        }
        log.debug("[Params]:");
        object2 = httpServletRequest.getParameterNames();
        while (object2.hasMoreElements()) {
            object = (String)object2.nextElement();
            string = httpServletRequest.getParameter((String)object);
            log.debug("\t\t{} = {}", object, (Object)string);
        }
        object = ClientInfoContext.getClientOSType();
        string = ClientInfoContext.getClientOSVersion();
        String string2 = ClientInfoContext.getClientAppVersion();
        String string3 = ClientInfoContext.getClientUsingBackendVersion();
        if (object != null || string != null || string2 != null || string3 != null) {
            log.debug("[Client]:");
            if (object != null) {
                log.debug("\t\tclient-os-type = {}", object);
            }
            if (string != null) {
                log.debug("\t\tclient-os-version = {}", (Object)string);
            }
            if (string2 != null) {
                log.debug("\t\tclient-app-version = {}", (Object)string2);
            }
            if (string3 != null) {
                log.debug("\t\tclient-using-backend-version = {}", (Object)string3);
            }
        }
        if (handlerMethod != null) {
            Method method = handlerMethod.getMethod();
            Class clazz = handlerMethod.getBeanType();
            boolean bl = method.getAnnotation(Deprecated.class) != null;
            boolean bl2 = clazz.getAnnotation(Deprecated.class) != null;
            log.debug("[Controller]:");
            log.debug("\t\ttype = {}{}", (Object)clazz.getName(), (Object)(bl ? "(Deprecated)" : ""));
            log.debug("\t\tmethod-name = {}{}", (Object)method.getName(), (Object)(bl2 ? "(Deprecated)" : ""));
        }
        log.debug(StringUtils.repeat((char)'-', (int)120));
    }

    private Locale getLocale() {
        try {
            return LocaleContextHolder.getLocale();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private String decode(String string) {
        try {
            return URLDecoder.decode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new AssertionError();
        }
    }
}

