/*
 * Decompiled with CFR 0.152.
 */
package com.github.yingzhuo.carnival.mvc.support;

import com.github.yingzhuo.carnival.mvc.IpAddress;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.springframework.core.MethodParameter;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

public class IpAddressHandlerMethodArgumentResolver
implements HandlerMethodArgumentResolver {
    public boolean supportsParameter(MethodParameter methodParameter) {
        boolean bl = methodParameter.hasParameterAnnotation(IpAddress.class) && methodParameter.getParameterType() == String.class;
        boolean bl2 = methodParameter.hasParameterAnnotation(IpAddress.class) && methodParameter.getParameterType() == Optional.class;
        return bl || bl2;
    }

    public Object resolveArgument(MethodParameter methodParameter, ModelAndViewContainer modelAndViewContainer, NativeWebRequest nativeWebRequest, WebDataBinderFactory webDataBinderFactory) {
        HttpServletRequest httpServletRequest = (HttpServletRequest)nativeWebRequest.getNativeRequest(HttpServletRequest.class);
        String string = null;
        if (httpServletRequest != null && !StringUtils.hasText((String)(string = this.getIpAddress(httpServletRequest)))) {
            string = null;
        }
        if (methodParameter.getParameterType() == String.class) {
            return string;
        }
        if (methodParameter.getParameterType() == Optional.class) {
            return Optional.ofNullable(string);
        }
        return null;
    }

    private String getIpAddress(HttpServletRequest httpServletRequest) {
        String string;
        block7: {
            block6: {
                string = httpServletRequest.getHeader("X-Forwarded-For");
                if (string != null && string.length() != 0 && !"unknown".equalsIgnoreCase(string)) break block6;
                if (string == null || string.length() == 0 || "unknown".equalsIgnoreCase(string)) {
                    string = httpServletRequest.getHeader("Proxy-Client-IP");
                }
                if (string == null || string.length() == 0 || "unknown".equalsIgnoreCase(string)) {
                    string = httpServletRequest.getHeader("WL-Proxy-Client-IP");
                }
                if (string == null || string.length() == 0 || "unknown".equalsIgnoreCase(string)) {
                    string = httpServletRequest.getHeader("HTTP_CLIENT_IP");
                }
                if (string == null || string.length() == 0 || "unknown".equalsIgnoreCase(string)) {
                    string = httpServletRequest.getHeader("HTTP_X_FORWARDED_FOR");
                }
                if (string != null && string.length() != 0 && !"unknown".equalsIgnoreCase(string)) break block7;
                string = httpServletRequest.getRemoteAddr();
                break block7;
            }
            if (string.length() > 15) {
                String[] stringArray;
                for (String string2 : stringArray = string.split(",")) {
                    if ("unknown".equalsIgnoreCase(string2)) continue;
                    string = string2;
                    break;
                }
            }
        }
        return string;
    }
}

