/*
 * Decompiled with CFR 0.152.
 */
package com.github.yingzhuo.carnival.mvc.filter;

import com.github.yingzhuo.carnival.spring.JacksonUtils;
import com.github.yingzhuo.carnival.spring.PathMatcherUtils;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.filter.OncePerRequestFilter;

public abstract class AbstractServletFilter
extends OncePerRequestFilter {
    protected static final String UTF_8 = "UTF-8";
    private String[] skipPatterns;

    protected final void doFilterInternal(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws ServletException, IOException {
        String string = httpServletRequest.getRequestURI();
        if (this.skipPatterns != null && this.skipPatterns.length > 0 && PathMatcherUtils.anyMatch((String)string, (String[])this.skipPatterns)) {
            filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
            return;
        }
        if (this.doFilter(httpServletRequest, httpServletResponse)) {
            filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
        }
    }

    protected abstract boolean doFilter(HttpServletRequest var1, HttpServletResponse var2) throws ServletException, IOException;

    protected final void writeJson(HttpServletResponse httpServletResponse, Object object) throws IOException {
        httpServletResponse.setContentType("application/json");
        httpServletResponse.setCharacterEncoding(UTF_8);
        httpServletResponse.getWriter().print(JacksonUtils.writeValueAsString((Object)object));
        httpServletResponse.getWriter().flush();
    }

    protected final void writeText(HttpServletResponse httpServletResponse, String string) throws IOException {
        httpServletResponse.setContentType("text/plain");
        httpServletResponse.setCharacterEncoding(UTF_8);
        httpServletResponse.getWriter().print(string);
        httpServletResponse.getWriter().flush();
    }

    protected final void writeHtml(HttpServletResponse httpServletResponse, String string) throws IOException {
        httpServletResponse.setContentType("text/html");
        httpServletResponse.setCharacterEncoding(UTF_8);
        httpServletResponse.getWriter().print(string);
        httpServletResponse.getWriter().flush();
    }

    public final void setSkipPatterns(String ... stringArray) {
        this.skipPatterns = stringArray;
    }
}

