/*
 * Decompiled with CFR 0.152.
 */
package com.github.yingzhuo.carnival.mvc.support;

import com.github.yingzhuo.carnival.mvc.IpAddress;
import com.github.yingzhuo.carnival.mvc.util.IPUtils;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import org.springframework.core.MethodParameter;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

public class IpAddressHandlerMethodArgumentResolver
implements HandlerMethodArgumentResolver {
    public boolean supportsParameter(MethodParameter methodParameter) {
        boolean bl = methodParameter.hasParameterAnnotation(IpAddress.class) && methodParameter.getParameterType() == String.class;
        boolean bl2 = methodParameter.hasParameterAnnotation(IpAddress.class) && methodParameter.getParameterType() == Optional.class;
        return bl || bl2;
    }

    public Object resolveArgument(MethodParameter methodParameter, ModelAndViewContainer modelAndViewContainer, NativeWebRequest nativeWebRequest, WebDataBinderFactory webDataBinderFactory) {
        HttpServletRequest httpServletRequest = (HttpServletRequest)nativeWebRequest.getNativeRequest(HttpServletRequest.class);
        String string = null;
        if (httpServletRequest != null && !StringUtils.hasText((String)(string = IPUtils.getIpAddress(httpServletRequest)))) {
            string = null;
        }
        if (methodParameter.getParameterType() == String.class) {
            return string;
        }
        if (methodParameter.getParameterType() == Optional.class) {
            return Optional.ofNullable(string);
        }
        return null;
    }
}

