/*
 * Decompiled with CFR 0.152.
 */
package com.github.yingzhuo.kushan.snowflake.impl;

import com.github.yingzhuo.kushan.snowflake.Scheme;
import com.github.yingzhuo.kushan.snowflake.SnowflakeClient;
import java.util.List;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.util.UriComponentsBuilder;

public class DefaultSnowflakeClient
implements SnowflakeClient {
    private final Scheme scheme;
    private final String hostname;
    private final int port;
    private final RestTemplate restTemplate = new RestTemplate();

    public DefaultSnowflakeClient(Scheme scheme, String string, int n) {
        this.scheme = scheme;
        this.hostname = string;
        this.port = n;
    }

    @Override
    public List<Long> nextIds(int n) {
        ResponseEntity responseEntity = this.restTemplate.exchange(this.getUrl(n), HttpMethod.GET, this.getHttpEntity(), (ParameterizedTypeReference)new ParameterizedTypeReference<List<Long>>(){}, new Object[0]);
        return (List)responseEntity.getBody();
    }

    private HttpEntity<?> getHttpEntity() {
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.set("Accept", "application/json");
        return new HttpEntity((MultiValueMap)httpHeaders);
    }

    private String getUrl(int n) {
        String string = String.format("%s://%s:%d/id", this.scheme.toString().toLowerCase(), this.hostname, this.port);
        UriComponentsBuilder uriComponentsBuilder = UriComponentsBuilder.fromHttpUrl((String)string).queryParam("number", new Object[]{n});
        return uriComponentsBuilder.toUriString();
    }
}

