/*
 * Decompiled with CFR 0.152.
 */
package com.github.yingzhuo.spring.security.simpletoken.core;

import com.github.yingzhuo.spring.security.core.AbstractAuthenticationFilter;
import com.github.yingzhuo.spring.security.exception.UserDetailsNotFoundException;
import com.github.yingzhuo.spring.security.simpletoken.core.UserDetailsFinder;
import com.github.yingzhuo.spring.security.simpletoken.errorhandler.SimpleTokenAuthenticationEntryPoint;
import com.github.yingzhuo.spring.security.simpletoken.resolver.SimpleTokenResolver;
import com.github.yingzhuo.spring.security.token.StringToken;
import java.io.IOException;
import java.util.Optional;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.web.authentication.NullRememberMeServices;
import org.springframework.security.web.authentication.RememberMeServices;
import org.springframework.security.web.authentication.WebAuthenticationDetailsSource;
import org.springframework.util.Assert;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.context.request.ServletWebRequest;

public class SimpleTokenAuthenticationFilter
extends AbstractAuthenticationFilter {
    private final SimpleTokenResolver tokenResolver;
    private final UserDetailsFinder userDetailsFinder;
    private RememberMeServices rememberMeServices = new NullRememberMeServices();
    private SimpleTokenAuthenticationEntryPoint simpleTokenAuthenticationEntryPoint;

    public SimpleTokenAuthenticationFilter(SimpleTokenResolver simpleTokenResolver, UserDetailsFinder userDetailsFinder) {
        this.tokenResolver = simpleTokenResolver;
        this.userDetailsFinder = userDetailsFinder;
        Assert.notNull((Object)simpleTokenResolver, () -> null);
        Assert.notNull((Object)userDetailsFinder, () -> null);
    }

    protected void doFilterInternal(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws ServletException, IOException {
        block4: {
            try {
                if (!this.authenticationIsRequired()) break block4;
                Optional<StringToken> optional = this.tokenResolver.resolve((NativeWebRequest)new ServletWebRequest(httpServletRequest, httpServletResponse));
                if (optional.isPresent()) {
                    StringToken stringToken = optional.get();
                    UserDetails userDetails = this.userDetailsFinder.find(stringToken);
                    if (userDetails != null) {
                        StringToken stringToken2 = new StringToken(userDetails.getAuthorities(), (CharSequence)stringToken.toString());
                        stringToken2.setPrincipal(userDetails);
                        stringToken2.setAuthenticated(true);
                        stringToken2.setDetails((Object)new WebAuthenticationDetailsSource().buildDetails(httpServletRequest));
                        SecurityContextHolder.getContext().setAuthentication((Authentication)stringToken2);
                        this.rememberMeServices.loginSuccess(httpServletRequest, httpServletResponse, (Authentication)stringToken2);
                        this.onSuccessfulAuthentication(httpServletRequest, httpServletResponse, (Authentication)stringToken2);
                    }
                    break block4;
                }
                throw new UserDetailsNotFoundException(null);
            }
            catch (AuthenticationException authenticationException) {
                SecurityContextHolder.clearContext();
                this.rememberMeServices.loginFail(httpServletRequest, httpServletResponse);
                this.onUnsuccessfulAuthentication(httpServletRequest, httpServletResponse, authenticationException);
                if (this.simpleTokenAuthenticationEntryPoint == null) break block4;
                this.simpleTokenAuthenticationEntryPoint.commence(httpServletRequest, httpServletResponse, authenticationException);
                return;
            }
        }
        filterChain.doFilter((ServletRequest)httpServletRequest, (ServletResponse)httpServletResponse);
    }

    public void afterPropertiesSet() throws ServletException {
        super.afterPropertiesSet();
    }

    public void setRememberMeServices(RememberMeServices rememberMeServices) {
        this.rememberMeServices = rememberMeServices;
    }

    public void setSimpleTokenAuthenticationEntryPoint(SimpleTokenAuthenticationEntryPoint simpleTokenAuthenticationEntryPoint) {
        this.simpleTokenAuthenticationEntryPoint = simpleTokenAuthenticationEntryPoint;
    }

    public SimpleTokenResolver getTokenResolver() {
        return this.tokenResolver;
    }

    public UserDetailsFinder getUserDetailsFinder() {
        return this.userDetailsFinder;
    }
}

