/*
 * Decompiled with CFR 0.152.
 */
package com.github.yingzhuo.spring.security.simpletoken.dsl;

import com.github.yingzhuo.spring.security.dsl.HttpConfigurerUtils;
import com.github.yingzhuo.spring.security.simpletoken.core.SimpleTokenAuthenticationFilter;
import com.github.yingzhuo.spring.security.simpletoken.core.UserDetailsFinder;
import com.github.yingzhuo.spring.security.simpletoken.errorhandler.SimpleTokenAuthenticationEntryPoint;
import com.github.yingzhuo.spring.security.simpletoken.resolver.SimpleTokenResolver;
import javax.servlet.Filter;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;

class SimpleTokenCustomHttpSecurityDSL
extends AbstractHttpConfigurer<SimpleTokenCustomHttpSecurityDSL, HttpSecurity> {
    SimpleTokenCustomHttpSecurityDSL() {
    }

    public void configure(HttpSecurity httpSecurity) throws Exception {
        SimpleTokenResolver simpleTokenResolver = (SimpleTokenResolver)HttpConfigurerUtils.getObject((HttpSecurity)httpSecurity, SimpleTokenResolver.class, null);
        UserDetailsFinder userDetailsFinder = (UserDetailsFinder)HttpConfigurerUtils.getObject((HttpSecurity)httpSecurity, UserDetailsFinder.class, null);
        if (simpleTokenResolver == null || userDetailsFinder == null) {
            return;
        }
        SimpleTokenAuthenticationFilter simpleTokenAuthenticationFilter = new SimpleTokenAuthenticationFilter(simpleTokenResolver, userDetailsFinder);
        simpleTokenAuthenticationFilter.setRememberMeServices(HttpConfigurerUtils.getRememberMeServices((HttpSecurity)httpSecurity));
        simpleTokenAuthenticationFilter.setSimpleTokenAuthenticationEntryPoint((SimpleTokenAuthenticationEntryPoint)((Object)HttpConfigurerUtils.getObject((HttpSecurity)httpSecurity, SimpleTokenAuthenticationEntryPoint.class, null)));
        simpleTokenAuthenticationFilter.afterPropertiesSet();
        httpSecurity.setSharedObject(SimpleTokenAuthenticationFilter.class, (Object)simpleTokenAuthenticationFilter);
        httpSecurity.setSharedObject(SimpleTokenResolver.class, (Object)simpleTokenResolver);
        httpSecurity.setSharedObject(UserDetailsFinder.class, (Object)userDetailsFinder);
        httpSecurity.addFilterAfter((Filter)simpleTokenAuthenticationFilter, BasicAuthenticationFilter.class);
    }
}

