/*
 * Decompiled with CFR 0.152.
 */
package com.github.yingzhuo.spring.security.simpletoken.resolver;

import com.github.yingzhuo.spring.security.simpletoken.resolver.SimpleTokenResolver;
import com.github.yingzhuo.spring.security.token.StringToken;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.springframework.web.context.request.NativeWebRequest;

final class CompositeSimpleTokenResolver
implements SimpleTokenResolver {
    private final List<SimpleTokenResolver> resolvers;

    private CompositeSimpleTokenResolver(SimpleTokenResolver ... simpleTokenResolverArray) {
        this.resolvers = Arrays.asList(simpleTokenResolverArray);
    }

    public static CompositeSimpleTokenResolver newInstance(SimpleTokenResolver ... simpleTokenResolverArray) {
        return new CompositeSimpleTokenResolver(simpleTokenResolverArray);
    }

    @Override
    public Optional<StringToken> resolve(NativeWebRequest nativeWebRequest) {
        if (this.resolvers.isEmpty()) {
            return Optional.empty();
        }
        for (SimpleTokenResolver simpleTokenResolver : this.resolvers) {
            Optional<StringToken> optional = simpleTokenResolver.resolve(nativeWebRequest);
            if (!optional.isPresent()) continue;
            return optional;
        }
        return Optional.empty();
    }
}

