/*
 * Decompiled with CFR 0.152.
 */
package com.github.yingzhuo.spring.security.simpletoken.resolver;

import com.github.yingzhuo.spring.security.simpletoken.resolver.SimpleTokenResolver;
import com.github.yingzhuo.spring.security.token.StringToken;
import java.util.Optional;
import org.springframework.web.context.request.NativeWebRequest;

class HttpHeaderSimpleTokenResolver
implements SimpleTokenResolver {
    private final String headerName;
    private final String prefix;
    private final int prefixLen;

    public HttpHeaderSimpleTokenResolver(String string) {
        this(string, "");
    }

    public HttpHeaderSimpleTokenResolver(String string, String string2) {
        if (string2 == null) {
            string2 = "";
        }
        this.headerName = string;
        this.prefix = string2;
        this.prefixLen = string2.length();
    }

    @Override
    public Optional<StringToken> resolve(NativeWebRequest nativeWebRequest) {
        String string = nativeWebRequest.getHeader(this.headerName);
        if (string == null || !string.startsWith(this.prefix)) {
            return Optional.empty();
        }
        string = string.substring(this.prefixLen);
        return Optional.of(new StringToken(string));
    }
}

