/*
 * Decompiled with CFR 0.152.
 */
package com.github.yingzhuo.spring.security.simpletoken.resolver;

import com.github.yingzhuo.spring.security.simpletoken.resolver.SimpleTokenResolver;
import com.github.yingzhuo.spring.security.token.StringToken;
import java.util.Optional;
import org.springframework.web.context.request.NativeWebRequest;

class HttpParamSimpleTokenResolver
implements SimpleTokenResolver {
    private final String paramName;
    private final String prefix;
    private final int prefixLen;

    public HttpParamSimpleTokenResolver(String string) {
        this(string, "");
    }

    public HttpParamSimpleTokenResolver(String string, String string2) {
        if (string2 == null) {
            string2 = "";
        }
        this.paramName = string;
        this.prefix = string2;
        this.prefixLen = string2.length();
    }

    @Override
    public Optional<StringToken> resolve(NativeWebRequest nativeWebRequest) {
        String string = nativeWebRequest.getParameter(this.paramName);
        if (string == null || !string.startsWith(this.prefix)) {
            return Optional.empty();
        }
        string = string.substring(this.prefixLen);
        return Optional.of(new StringToken(string));
    }
}

