/*
 * Decompiled with CFR 0.152.
 */
package com.github.yingzhuo.spring.security.simpletoken.resolver;

import com.github.yingzhuo.spring.security.simpletoken.resolver.CompositeSimpleTokenResolver;
import com.github.yingzhuo.spring.security.simpletoken.resolver.HttpHeaderSimpleTokenResolver;
import com.github.yingzhuo.spring.security.simpletoken.resolver.HttpParamSimpleTokenResolver;
import com.github.yingzhuo.spring.security.simpletoken.resolver.SimpleTokenResolver;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public final class SimpleTokenResolverBuilder {
    private final List<SimpleTokenResolver> list = new ArrayList<SimpleTokenResolver>();

    SimpleTokenResolverBuilder() {
    }

    public SimpleTokenResolverBuilder fromHttpParameter(String string, String string2) {
        this.list.add(new HttpParamSimpleTokenResolver(string, string2));
        return this;
    }

    public SimpleTokenResolverBuilder fromHttpParameter(String string) {
        return this.fromHttpParameter(string, "");
    }

    public SimpleTokenResolverBuilder fromHttpHeader(String string, String string2) {
        this.list.add(new HttpHeaderSimpleTokenResolver(string, string2));
        return this;
    }

    public SimpleTokenResolverBuilder fromHttpHeader(String string) {
        return this.fromHttpHeader(string, "");
    }

    public SimpleTokenResolverBuilder add(SimpleTokenResolver ... simpleTokenResolverArray) {
        this.list.addAll(Arrays.asList(simpleTokenResolverArray));
        return this;
    }

    public SimpleTokenResolver build() {
        if (this.list.isEmpty()) {
            return nativeWebRequest -> Optional.empty();
        }
        if (this.list.size() == 1) {
            return this.list.get(0);
        }
        return CompositeSimpleTokenResolver.newInstance(this.list.toArray(new SimpleTokenResolver[0]));
    }
}

