/*                 _                                            _ _                           _       _
 *  ___ _ __  _ __(_)_ __   __ _       ___  ___  ___ _   _ _ __(_) |_ _   _       _ __   __ _| |_ ___| |__
 * / __| '_ \| '__| | '_ \ / _` |_____/ __|/ _ \/ __| | | | '__| | __| | | |_____| '_ \ / _` | __/ __| '_ \
 * \__ \ |_) | |  | | | | | (_| |_____\__ \  __/ (__| |_| | |  | | |_| |_| |_____| |_) | (_| | || (__| | | |
 * |___/ .__/|_|  |_|_| |_|\__, |     |___/\___|\___|\__,_|_|  |_|\__|\__, |     | .__/ \__,_|\__\___|_| |_|
 *     |_|                 |___/                                      |___/      |_|
 *
 *  https://github.com/yingzhuo/spring-security-patch
 */
package com.github.yingzhuo.spring.security.simpletoken.core;

import com.github.yingzhuo.spring.security.token.StringToken;
import org.springframework.security.core.userdetails.UserDetails;

import java.util.function.Function;

/**
 * @author 应卓
 * @since 1.3.1
 */
@FunctionalInterface
public interface UserDetailsFinder extends Function<StringToken, UserDetails> {

    public UserDetails find(StringToken stringToken);

    @Override
    public default UserDetails apply(StringToken stringToken) {
        return find(stringToken);
    }

}
