/*                 _                                            _ _                           _       _
 *  ___ _ __  _ __(_)_ __   __ _       ___  ___  ___ _   _ _ __(_) |_ _   _       _ __   __ _| |_ ___| |__
 * / __| '_ \| '__| | '_ \ / _` |_____/ __|/ _ \/ __| | | | '__| | __| | | |_____| '_ \ / _` | __/ __| '_ \
 * \__ \ |_) | |  | | | | | (_| |_____\__ \  __/ (__| |_| | |  | | |_| |_| |_____| |_) | (_| | || (__| | | |
 * |___/ .__/|_|  |_|_| |_|\__, |     |___/\___|\___|\__,_|_|  |_|\__|\__, |     | .__/ \__,_|\__\___|_| |_|
 *     |_|                 |___/                                      |___/      |_|
 *
 *  https://github.com/yingzhuo/spring-security-patch
 */
package com.github.yingzhuo.spring.security.simpletoken.dsl;

import com.github.yingzhuo.spring.security.simpletoken.core.SimpleTokenAuthenticationFilter;
import com.github.yingzhuo.spring.security.simpletoken.core.UserDetailsFinder;
import com.github.yingzhuo.spring.security.simpletoken.errorhandler.SimpleTokenAuthenticationEntryPoint;
import com.github.yingzhuo.spring.security.simpletoken.resolver.SimpleTokenResolver;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configurers.AbstractHttpConfigurer;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;

import static com.github.yingzhuo.spring.security.dsl.HttpConfigurerUtils.getObject;
import static com.github.yingzhuo.spring.security.dsl.HttpConfigurerUtils.getRememberMeServices;

/**
 * @author 应卓
 * @since 1.3.1
 */
class SimpleTokenCustomHttpSecurityDSL extends AbstractHttpConfigurer<SimpleTokenCustomHttpSecurityDSL, HttpSecurity> {

    @Override
    public void configure(HttpSecurity http) throws Exception {

        // Token解析器 (nullable)
        final SimpleTokenResolver resolver = getObject(http, SimpleTokenResolver.class, null);

        // 查找器 (nullable)
        final UserDetailsFinder finder = getObject(http, UserDetailsFinder.class, null);

        if (resolver == null || finder == null) {
            return;
        }

        final SimpleTokenAuthenticationFilter filter = new SimpleTokenAuthenticationFilter(resolver, finder);
        filter.setRememberMeServices(getRememberMeServices(http));
        filter.setSimpleTokenAuthenticationEntryPoint(getObject(http, SimpleTokenAuthenticationEntryPoint.class, null));
        filter.afterPropertiesSet();

        // 共享对象
        http.setSharedObject(SimpleTokenAuthenticationFilter.class, filter);
        http.setSharedObject(SimpleTokenResolver.class, resolver);
        http.setSharedObject(UserDetailsFinder.class, finder);

        // 设置Jwt认证过滤器
        http.addFilterAfter(filter, BasicAuthenticationFilter.class);
    }

}
