/*                 _                                            _ _                           _       _
 *  ___ _ __  _ __(_)_ __   __ _       ___  ___  ___ _   _ _ __(_) |_ _   _       _ __   __ _| |_ ___| |__
 * / __| '_ \| '__| | '_ \ / _` |_____/ __|/ _ \/ __| | | | '__| | __| | | |_____| '_ \ / _` | __/ __| '_ \
 * \__ \ |_) | |  | | | | | (_| |_____\__ \  __/ (__| |_| | |  | | |_| |_| |_____| |_) | (_| | || (__| | | |
 * |___/ .__/|_|  |_|_| |_|\__, |     |___/\___|\___|\__,_|_|  |_|\__|\__, |     | .__/ \__,_|\__\___|_| |_|
 *     |_|                 |___/                                      |___/      |_|
 *
 *  https://github.com/yingzhuo/spring-security-patch
 */
package com.github.yingzhuo.spring.security.simpletoken.resolver;

import com.github.yingzhuo.spring.security.token.StringToken;
import org.springframework.web.context.request.NativeWebRequest;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;

/**
 * @author 应卓
 * @since 1.3.1
 */
final class CompositeSimpleTokenResolver implements SimpleTokenResolver {

    private final List<SimpleTokenResolver> resolvers;

    private CompositeSimpleTokenResolver(SimpleTokenResolver... resolvers) {
        this.resolvers = Arrays.asList(resolvers);
    }

    public static CompositeSimpleTokenResolver newInstance(SimpleTokenResolver... resolvers) {
        return new CompositeSimpleTokenResolver(resolvers);
    }

    @Override
    public Optional<StringToken> resolve(NativeWebRequest request) {
        if (resolvers.isEmpty()) {
            return Optional.empty();
        }

        for (SimpleTokenResolver resolver : resolvers) {
            Optional<StringToken> op = resolver.resolve(request);
            if (op.isPresent()) return op;
        }

        return Optional.empty();
    }

}
