/*                 _                                            _ _                           _       _
 *  ___ _ __  _ __(_)_ __   __ _       ___  ___  ___ _   _ _ __(_) |_ _   _       _ __   __ _| |_ ___| |__
 * / __| '_ \| '__| | '_ \ / _` |_____/ __|/ _ \/ __| | | | '__| | __| | | |_____| '_ \ / _` | __/ __| '_ \
 * \__ \ |_) | |  | | | | | (_| |_____\__ \  __/ (__| |_| | |  | | |_| |_| |_____| |_) | (_| | || (__| | | |
 * |___/ .__/|_|  |_|_| |_|\__, |     |___/\___|\___|\__,_|_|  |_|\__|\__, |     | .__/ \__,_|\__\___|_| |_|
 *     |_|                 |___/                                      |___/      |_|
 *
 *  https://github.com/yingzhuo/spring-security-patch
 */
package com.github.yingzhuo.spring.security.simpletoken.resolver;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

/**
 * @author 应卓
 * @since 1.3.1
 */
public final class SimpleTokenResolverBuilder {

    private final List<SimpleTokenResolver> list = new ArrayList<>();

    SimpleTokenResolverBuilder() {
    }

    public SimpleTokenResolverBuilder fromHttpParameter(String parameterName, String prefix) {
        list.add(new HttpParamSimpleTokenResolver(parameterName, prefix));
        return this;
    }

    public SimpleTokenResolverBuilder fromHttpParameter(String parameterName) {
        return fromHttpParameter(parameterName, "");
    }

    public SimpleTokenResolverBuilder fromHttpHeader(String headerName, String prefix) {
        list.add(new HttpHeaderSimpleTokenResolver(headerName, prefix));
        return this;
    }

    public SimpleTokenResolverBuilder fromHttpHeader(String headerName) {
        return fromHttpHeader(headerName, "");
    }

    public SimpleTokenResolverBuilder add(SimpleTokenResolver... others) {
        if (others != null && others.length != 0) {
            list.addAll(Arrays.asList(others));
        }
        return this;
    }

    public SimpleTokenResolver build() {

        if (list.isEmpty()) {
            return request -> Optional.empty();
        }

        if (list.size() == 1) {
            return list.get(0);
        } else {
            return CompositeSimpleTokenResolver.newInstance(list.toArray(new SimpleTokenResolver[0]));
        }
    }

}
