/*
 * Decompiled with CFR 0.152.
 */
package spring.turbo.module.captcha;

import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.util.Objects;
import org.springframework.lang.NonNull;
import spring.turbo.io.ImageUtils;
import spring.turbo.module.captcha.Captcha;
import spring.turbo.util.Asserts;

public final class EncodedCaptcha
implements Serializable {
    private static final String IMAGE_FORMAT = "png";
    private final Captcha captcha;
    private final String encodedImage;

    private EncodedCaptcha(Captcha captcha) {
        this.captcha = captcha;
        this.encodedImage = ImageUtils.encodeToBase64((BufferedImage)captcha.getImage(), (String)IMAGE_FORMAT);
    }

    public static EncodedCaptcha of(@NonNull Captcha captcha) {
        Asserts.notNull((Object)captcha);
        Asserts.notNull((Object)captcha.getWord());
        Asserts.notNull((Object)captcha.getImage());
        return new EncodedCaptcha(captcha);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        EncodedCaptcha encodedCaptcha = (EncodedCaptcha)object;
        return this.captcha.equals(encodedCaptcha.captcha);
    }

    public int hashCode() {
        return Objects.hash(this.captcha);
    }

    public String getWord() {
        return this.captcha.getWord();
    }

    public BufferedImage getImage() {
        return this.captcha.getImage();
    }

    public String getEncodedImage() {
        return this.encodedImage;
    }
}

